/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;

public class TestASTConstruction
extends BaseTest {
    public void testA() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : A;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT A <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testNakeRulePlusInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nA : B+;\nB : 'a';");
        String expecting = " ( rule A ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT B <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"A").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testRulePlus() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (b)+;\nb : B;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testNakedRulePlus() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b+;\nb : B;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testRuleOptional() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (b)?;\nb : B;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testNakedRuleOptional() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b?;\nb : B;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testRuleStar() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : (b)*;\nb : B;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testNakedRuleStar() throws Exception {
        Grammar g = new Grammar("parser grammar P;\na : b*;\nb : B;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT b <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testCharStar() throws Exception {
        Grammar g = new Grammar("grammar P;\na : 'a'*;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testCharStarInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nB : 'b'*;");
        String expecting = " ( rule B ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testStringStar() throws Exception {
        Grammar g = new Grammar("grammar P;\na : 'while'*;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'while' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testStringStarInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nB : 'while'*;");
        String expecting = " ( rule B ARG RET scope ( BLOCK ( ALT ( * ( BLOCK ( ALT 'while' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testCharPlus() throws Exception {
        Grammar g = new Grammar("grammar P;\na : 'a'+;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testCharPlusInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nB : 'b'+;");
        String expecting = " ( rule B ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testCharOptional() throws Exception {
        Grammar g = new Grammar("grammar P;\na : 'a'?;");
        String expecting = " ( rule a ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT 'a' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"a").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testCharOptionalInLexer() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nB : 'b'?;");
        String expecting = " ( rule B ARG RET scope ( BLOCK ( ALT ( ? ( BLOCK ( ALT 'b' <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"B").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }

    public void testCharRangePlus() throws Exception {
        Grammar g = new Grammar("lexer grammar P;\nID : 'a'..'z'+;");
        String expecting = " ( rule ID ARG RET scope ( BLOCK ( ALT ( + ( BLOCK ( ALT ( .. 'a' 'z' ) <end-of-alt> ) <end-of-block> ) ) <end-of-alt> ) <end-of-block> ) <end-of-rule> )";
        String found = g.getRule((String)"ID").tree.toStringTree();
        TestASTConstruction.assertEquals((String)expecting, (String)found);
    }
}

