/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.test.web.servlets;

import java.io.IOException;
 
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.web.tomcat.security.login.WebAuthentication;

//$Id$

/**
 *  JBAS-4077: Programmatic Web Login
 *  Servlet picks up the username, password from the request parameters
 *  and then does the web authentication
 *  @author Anil.Saldhana@redhat.com
 *  @since  Mar 12, 2007 
 *  @version $Revision$
 */
public class ProgrammaticLoginTestServlet extends HttpServlet
{ 
   private static final long serialVersionUID = 1L;

   protected void service(HttpServletRequest request, HttpServletResponse response) 
   throws ServletException, IOException
   {  
      String username = request.getParameter("username");
      String pass = request.getParameter("pass");
       
      if(username == null || pass == null)
            throw new RuntimeException("username or password is null");
      WebAuthentication pwl = new WebAuthentication(); 
      pwl.login(username, pass);  
       
      //Only when there is web login, does the principal be visible
      log("User Principal="+request.getUserPrincipal());
      log("isUserInRole(Authorized User)="+request.isUserInRole("AuthorizedUser"));
      if(request.getUserPrincipal() == null || !request.isUserInRole("AuthorizedUser"))
         throw new ServletException("User is not authenticated or the isUserInRole check failed");
      
      
      //Log the user out
      pwl.logout();
      
      if(request.getUserPrincipal() != null || request.isUserInRole("AuthorizedUser"))
         throw new ServletException("User is still authenticated or pass: isUserInRole(Authorized User)"); 
   } 
}
