/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *   Copyright (C) 2002, 2003 Richard P. Howell IV.                        * 
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KFOLDINGMOLECULEWIDGET_H
#define KFOLDINGMOLECULEWIDGET_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <time.h>

#include <qgl.h>

/**
@author Kevin Hessels
*/
class kfoldingConfigData;

class kfoldingMoleculeWidget : public QGLWidget
{

Q_OBJECT

public:
	kfoldingMoleculeWidget( QWidget* parent = 0L, const char* name = 0L, kfoldingConfigData* cfg = 0L );
	virtual ~kfoldingMoleculeWidget();
    
	void setOptions();
	void zoomIn();
	void zoomOut();
	
public slots:
	void update();


	
signals:
	void leftDrag( QPoint, QPoint );
	void rightDrag( QPoint, QPoint );
	void drawComplete();
	
protected:
	virtual void mousePressEvent( QMouseEvent * );
	virtual void mouseReleaseEvent( QMouseEvent * );
#ifndef QT_NO_WHEELEVENT
	virtual void wheelEvent( QWheelEvent* );
#endif
	virtual void initializeGL();
	virtual void resizeGL( int, int );
	virtual void paintGL();
	
private slots:
	void slotRotate( QPoint, QPoint );
	void slotTranslate( QPoint, QPoint );

private:
	int sq( int );
	void rot2(float, float *, float *);
	unsigned long color( float, float, float );
	void bondparm(struct atm *, struct atm *, struct bnd *);
	float biscale();
	void bibond(float s);
	void xyzclean();
	void achain();
	int readxyz();
	int dobond( struct bnd *, int );
	void draw_molecule();
	void draw_scene();

#ifndef HAVE_GL_GLU_H
	void dCylinder(float r, float h, int n);
	void dSphere(float r, int n);
#endif
	
	kfoldingConfigData* _config;
	QPoint	_leftDragStartPos;
	QPoint	_rightDragStartPos;
	
	bool _optionsSet;
	int _zoomLevel;
	
	float _rotx, _roty, _rotz;	/* current rotation */
	float _dvx, _dvy, _dvz;		/* current direction of view */
	float _ox, _oy, _oz;		/* current origin, for zoom and rotation */
	float _zoom;			/* Zoom factor */
	float _zdist;
	float _scale;			/* Scale factor for normalizing molecule size */
	float _xspan, _yspan;
	int _xsiz, _ysiz;
	int _model;			/* The currently displayed model type */
	int _numAtoms;			/* Total number of atoms in "atom" table */
	struct atm *_atom;		/* Pointer to allocated storage for all XYZ file data */
	struct adist *patom;		/* Pointer to auxiliary pointer table for sorting */
	float _fov;			/* Current field of view (degrees) */
	float _bond_radius;		/* Scaled bond thickness (displayed as cylinder) */
	int _nh2o;			/* Number of h2o molecules */
	int _oflags;			/* Current options selections */
	

	char pname[32];			/* Name of protein */
	char *argv0;			/* Name of program */
	unsigned int qver;		/* Queue version number, from queue or best guess */
	bool eswap;			/* Queue file with opposite endianness (default FALSE) */
	char *xyzfile;			/* Name of XYZ file */
	time_t xyztime;			/* Modification time of XYZ file */
	
	int bselect;
	int lmbselect;
	int lsbselect;
	
	char wbuf[200];
	char errmsg[200];
	char filname[300];
	char xyzname[300];
	char ebuf[8];

	
	float nearest;
	int qiselect;
	int bpselect;
	
	
#ifdef HAVE_GL_GLU_H
	GLUquadricObj *qobj;
#endif
	
	/* Saved values from the currently rendered display */
	
	int cmodel;
	float czoom;
	int cstflg;
	float csdctr;
	float cdqctr;
	float cbsbsiz;
	int coflags;
};

#endif
