#!/bin/sh
# Add symbolic link in ffmpeg cvs tree: x86_64 -> i386

SVN="/usr/src/ffmpeg"
HOME=`echo ~`
DEST="$HOME/files/code/linux/kmediafactory/ffmpeg"

DIRS=(
  "libavcodec"
  "libavcodec/x86_64"
  "libavformat"
  "libavutil"
)

function update_svn()
{
  echo -n "Update svn (y/N): "
  read ans
  if [ "$ans" == y -o "$ans" == Y ]
  then
    cd $SVN
    svn update
  fi
}

function check_new_files()
{
  for DIR in "${DIRS[@]}"; do
    echo "---------- $DIR ----------"
    cd "$SVN/$DIR"
    for file in $1; do
      if [ ! -e "$DEST/$DIR/$file" ]; then
        echo $file
        cp $SVN/$DIR/$file $DEST/$DIR/$file
      fi
    done
  done
}

function check_removed_files()
{
  for DIR in "${DIRS[@]}"; do
    echo "---------- $DIR ----------"
    cd "$DEST/$DIR"
    for file in $1; do
      if [ ! -e "$SVN/$DIR/$file" ]; then
        echo $file
        rm $DEST/$DIR/$file
      fi
    done
  done
}

function check_modified_files()
{
  for DIR in "${DIRS[@]}"; do
    echo "---------- $DIR ----------"
    cd "$SVN/$DIR"
    for file in $1; do
      if [ -e "$DEST/$DIR/$file" ]; then
        DIFF=`diff $file "$DEST/$DIR/$file"`
        if [ "$DIFF" != "" ]; then
          echo $file
          cp $SVN/$DIR/$file $DEST/$DIR/$file
        fi
      fi
    done
  done
}

update_svn

echo "********** Modified files **********"
check_modified_files "*.h *.c"
echo "********** REMOVED FILES **********"
check_removed_files "*.h *.c"
echo "********** New files **********"
check_new_files "*.h *.c"
