/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _COLORLISTVIEWITEM_H_
#define _COLORLISTVIEWITEM_H_

#include <klistview.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qtextedit.h>

//extern "C" {
#include "game_list.h"
#include "gxmame.h"
//}

class ColorListViewItem : public KListViewItem
{
    friend class KListView;
    public:
	RomEntry *mRom;
	uint mIndex; // mRom is for sequential access while index is for random access.
	QListViewItem *mParentGameItem;

	ColorListViewItem(QListView *parent)
		: KListViewItem(parent)
	{mParentGameItem = NULL; mRom=NULL; mIndex=0; clone=FALSE;}
	
	ColorListViewItem(QListViewItem *parent)
		: KListViewItem(parent)
	{mParentGameItem = NULL; mRom=NULL; mIndex=0; clone=FALSE;}

	ColorListViewItem(QListView *parent, const QString &label1, const QString &label2)
		: KListViewItem(parent, label1, label2)
	{mParentGameItem = NULL; mRom=NULL; mIndex=0; clone=FALSE;}
	
	ColorListViewItem(QListViewItem *parent, const QString &label1, const QString &label2)
		: KListViewItem(parent, label1, label2)
	{mParentGameItem = NULL; mRom=NULL; mIndex=0; clone=FALSE;}
	
	//overiding klistview paintCell to preserve alternating background
        virtual void paintCell(QPainter *painter, const QColorGroup &cg,
		       int column, int width, int align);

	void setupGameListViewItem(RomEntry *tmprom, uint index, bool isClone, const QPixmap &icon);

private:
	bool clone;
	
protected:
	QString column_value (int);
	
};

class FilterListViewItem : public KListViewItem
{
	friend class KListView;
	public:
		gint folderID;
		folder_filters_list folderType;
		gchar *folderValue;
		
		FilterListViewItem(QListView *parent)
		: KListViewItem(parent)
		{folderValue = NULL;}
	
		FilterListViewItem(QListViewItem *parent)
		: KListViewItem(parent)
		{folderValue = NULL;}

		FilterListViewItem(QListView *parent, const QString &label1)
		: KListViewItem(parent, label1)
		{folderValue = NULL;}
	
		FilterListViewItem(QListViewItem *parent, const QString &label1)
		: KListViewItem(parent, label1)
		{folderValue = NULL;}

};


#endif
