/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qimage.h>
#include <qpixmap.h>
#include <qstyle.h>
#include <qwidget.h>
#include <qcolor.h>
#include <qnamespace.h>

#include "kxmamesnaplabel.h"

kxmameSnapLabel::kxmameSnapLabel( QWidget *parent, const char* name, WFlags f ):
	QScrollView(parent, name, f) 
{
	setResizePolicy (QScrollView::AutoOneFit);
	viewport()->setPaletteBackgroundColor(QColor(255,255,255));
	scaledContents = TRUE;
	mPixmap = NULL;
	mLabel = new QLabel(this);
	mLabel->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter );
	addChild(mLabel);
	mLabel->setPaletteBackgroundColor(QColor(255,255,255));
	mLabel->hide();
	setVScrollBarMode (QScrollView::AlwaysOff);
	setHScrollBarMode (QScrollView::AlwaysOff);
	isOn = TRUE;
}

kxmameSnapLabel::~kxmameSnapLabel()
{
	if (mPixmap)
		delete mPixmap;
	delete mLabel;
}

void kxmameSnapLabel::setPixmap (const QPixmap &pix )
{
	if ( (mPixmap) && (mPixmap->serialNumber() == pix.serialNumber()) )
		return;
	
	if (mPixmap)	delete mPixmap;
	mPixmap = new QPixmap(pix);
	mLabel->setPixmap(pix);
	repaintContents();
}

void kxmameSnapLabel::setOnOff( bool state)
{
	isOn = state;
	if(!isOn) { mLabel->hide(); hide(); }
	else	{ show(); repaintContents(); }
}

void kxmameSnapLabel::setScaledContents(bool state) 
{
	if (scaledContents == state ) return;
	
	scaledContents = state;
	if (!state) {
		if(isOn) mLabel->show();
		setVScrollBarMode (QScrollView::Auto);
		setHScrollBarMode (QScrollView::Auto);
	} else {
		mLabel->hide();
		setVScrollBarMode (QScrollView::AlwaysOff);
		setHScrollBarMode (QScrollView::AlwaysOff);
	}
	repaintContents();
}

void kxmameSnapLabel::drawContents(QPainter *p, int x, int y, int w, int h)
{
	if(!isOn) return;
	
	if (scaledContents) {
		QPixmap *pix = mPixmap;
		if ( pix ) {
			QRect cr = viewport()->rect();
			QPixmap pic = QPixmap();
			QImage img = QImage( pix->convertToImage() );
			pic.convertFromImage( img.smoothScale( cr.width(), cr.height(), QImage::ScaleMin ) );
			viewport()->erase();
			p->drawPixmap ((cr.width()-pic.width())/2,(cr.height()-pic.height())/2,pic);
		}
		return;
	} else 
		mLabel->show();
	
	QScrollView::drawContents(p, x, y, w, h );
}

#include "kxmamesnaplabel.moc"
