/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.classloading.spi;

import java.net.URL;

import javax.management.ObjectName;

import org.jboss.util.loading.Translatable;

/**
 * RealClassLoader.<p>
 * 
 * A tagging interface for RealClassLoaders
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public interface RealClassLoader extends Translatable
{
   /**
    * Get the object name for this classloader
    *
    * @return the object name
    */
   ObjectName getObjectName();

   /**
    * Whether the classloader is valid
    * 
    * @return true when valid
    */
   boolean isValid();
   
   /**
    * Check the cache to see if the class is already loaded
    * 
    * @param name the class name
    * @return the class or null if not cached
    */
   Class<?> getCachedClass(String name);

   /**
    * Check the cache to see if the resource is already loaded
    * 
    * @param name the name of the resource
    * @return the resource url or null if not cached
    */
   URL getCachedResource(String name);
}
