/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.remoting.detection.jndi.deadlock;

import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 * @author Michael Voss
 */
public class ClientAuthSocketFactory extends SSLServerSocketFactory
{
   SSLServerSocketFactory serverSocketFactory;

   public ClientAuthSocketFactory(SSLServerSocketFactory serverSocketFactory)
   {
      this.serverSocketFactory = serverSocketFactory;
   }

   public ServerSocket createServerSocket() throws IOException
   {
      SSLServerSocket ss = (SSLServerSocket) serverSocketFactory.createServerSocket();
      ss.setNeedClientAuth(true);
      return ss;
   }

   public ServerSocket createServerSocket(int arg0) throws IOException
   {
      SSLServerSocket ss = (SSLServerSocket) serverSocketFactory.createServerSocket(arg0);
      ss.setNeedClientAuth(true);
      return ss;
   }

   public ServerSocket createServerSocket(int arg0, int arg1) throws IOException
   {
      SSLServerSocket ss = (SSLServerSocket) serverSocketFactory.createServerSocket(arg0, arg1);
      ss.setNeedClientAuth(true);
      return ss;
   }

   public ServerSocket createServerSocket(int arg0, int arg1, InetAddress arg2) throws IOException
   {
      SSLServerSocket ss = (SSLServerSocket) serverSocketFactory.createServerSocket(arg0, arg1, arg2);
      ss.setNeedClientAuth(true);
      return ss;

   }

   public boolean equals(Object obj)
   {
      return serverSocketFactory.equals(obj);
   }

   public String[] getDefaultCipherSuites()
   {
      return serverSocketFactory.getDefaultCipherSuites();
   }

   public String[] getSupportedCipherSuites()
   {
      return serverSocketFactory.getSupportedCipherSuites();
   }

   public int hashCode()
   {
      return serverSocketFactory.hashCode();
   }

   public String toString()
   {
      return serverSocketFactory.toString();
   }
}
