/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.remoting.transporter.ssl;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transporter.TransporterClient;

import java.net.MalformedURLException;


public class Client
{
   /**
    * the Object containing all information about the Server location
    */
   protected InvokerLocator locator;

   /**
    * Constructor - initializes the locator and sets properties
    */
   public Client(String user)
   {
      if (user == "user1")
      {

         String keyStoreFilePath = this.getClass().getResource("certificate/.keystore").getFile();
         String trustStoreFilePath = this.getClass().getResource("certificate/.truststore").getFile();

         System.setProperty(SSLSocketBuilder.STANDARD_KEY_STORE_FILE_PATH,
                            keyStoreFilePath);
         System.setProperty(SSLSocketBuilder.STANDARD_KEY_STORE_PASSWORD,
                            "unit-tests-server");
         System.setProperty(SSLSocketBuilder.STANDARD_TRUST_STORE_FILE_PATH,
                            trustStoreFilePath);
         System.setProperty(SSLSocketBuilder.STANDARD_TRUST_STORE_PASSWORD,
                            "unit-tests-client");
         System.setProperty(InvokerLocator.FORCE_REMOTE, "true");
      }
      if (user == "user2")
      {
         System.setProperty(SSLSocketBuilder.STANDARD_KEY_STORE_FILE_PATH,
                            "./certificates/client/user2.keystore");
         System.setProperty(SSLSocketBuilder.STANDARD_KEY_STORE_PASSWORD,
                            "client");
         System.setProperty(SSLSocketBuilder.STANDARD_TRUST_STORE_FILE_PATH,
                            "./certificates/client/user2.truststore");
         System.setProperty(SSLSocketBuilder.STANDARD_TRUST_STORE_PASSWORD,
                            "client");
         System.setProperty(InvokerLocator.FORCE_REMOTE, "true");
      }

      try
      {
         locator = new InvokerLocator("sslsocket://127.0.0.1:7070");
      }
      catch (MalformedURLException e)
      {
         e.printStackTrace();
      }
   }

   /**
    * reqests the Server for an handle
    */
   public void requestHandle()
   {
      HandlerInterface handler = null;
      try
      {
         handler = (HandlerInterface) TransporterClient
               .createTransporterClient(locator, HandlerInterface.class);
         System.out.println("server returned: " + handler.doHandle());

      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      finally
      {
         if (handler != null)
         {
            TransporterClient.destroyTransporterClient(handler);
         }
      }
   }

   public static void main(String[] args)
   {
      System.out.println("starting client for claudia");
      Client client = new Client("user1");// is trusted

      // should print a String
      client.requestHandle();

      System.out.println("starting client for michael");
      Client client2 = new Client("user2");// is not trusted

      // should not print a String but throw an exception
      client2.requestHandle();
   }
}
