/* ============================================================
 * File  : harvester.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2004-03-08
 * Description : scans url for links (streams)
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */


#include <qregexp.h>
#include <qdom.h>

#include "harvester.h"

// Basic parsing for now. See podcast.pl for more data

using namespace std;


bool readTextFile(QString fileName, QString *data)
{
    QFile f(fileName);
    if ( f.open( IO_ReadOnly ) )
    {
      *data = (QString)f.readAll(); 
      f.close();
      return true;
    }
      else
        return false;
}


NewUrl::NewUrl(QString& nUrl, QString& nName, QString& nDescr) : QObject()
{
  name    = nName;
  url     = nUrl;
  descr   = nDescr;
  handler = "";
  
}

Parser::Parser() : QObject()
{
	list.setAutoDelete(true);
}

Parser::~Parser()
{
  list.clear();
}

UrlList* Parser::parse(QString& data)
{
   source = &data;
   run();
   
   return &list;
}


void Parser::run()
{
    // data to parse: *source.

    // general
    QRegExp expr;
    expr.setCaseSensitive(false);

    QString name, url, descr, handler;
    
    list.clear();

    // got mem?
    QDomDocument doc;
    doc.setContent(*source);
    QDomElement docElem = doc.documentElement();
    QDomNodeList nodes = docElem.elementsByTagName("Channels");
    QDomNode node;
    QDomElement elem, selem;

    NewUrl *urlObj = 0;
    
    for ( unsigned int i = 0; i < nodes.length(); i++)
    {
        node = nodes.item(i);
        elem = node.toElement();
        if ( !elem.isNull() )
        {
          selem = elem.namedItem("Channel_Name").toElement();
          name = selem.text();
          selem = elem.namedItem("Program_x0020_Name").toElement();
          descr = selem.text();
          selem = elem.namedItem("Channel_x0020_URL").toElement();
          url = selem.text();
          handler = "";

          
	        urlObj = new NewUrl(url, name, descr);
          urlObj->handler = handler;
           
          list.append( urlObj );
        }
    }

}


