#! /usr/bin/perl
#* ============================================================
# * File  : robins_links.pl
# * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
# * Date  : 2006-10-04
# * Description : BBC links for Robin Gilks parsers
# *        
# * ============================================================ */

use English;
use XML::Simple;
use XML::DOM;

# create object
$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line
my $bitrate = "";

open( FD, "<bbc/links.txt" );
@list = <FD>;
close FD;

foreach my $entry (@list)
{
  $item = $doc->createElement('item');
  $root->appendChild($item);

  $_ = $entry;
  ($name, $url) = m/(.*),\s*(.*)/;
    
  $item->appendChild( newNode('name' , $name) );
  $item->appendChild( newNode('url'  , $url ) );
  $item->appendChild( newNode('descr', ""   ) );
      
  if ( $name =~ m/^Live:/ )
  {
    $item->appendChild( newNode('handler', ""   ) );
  }
  else
  {
    $item->appendChild( newNode('handler', "bbc/bbc_l1"   ) );
  }
}


print $head->toString;
print $root->toString;
print "\n";


#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


