#! /usr/bin/perl
#* ============================================================
# * File        : dailymotion/vid.pl
# * Version     : 0.1
# * Author      : 
# * Date        : 2007-09-02
# * Description: parser for dailymotion feeds
# *
# * Requires:
# * - mythstream v0.17_2+
# *
# * ============================================================ */

use English;
use XML::DOM;
use HTML::Entities;

#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line
$sname = $in[2];

# remove quotes from sname
$sname =~ s/^\"?(.*?)\"?$/$1/;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO);

#------------------------------------------------------------------------------
# Parse playlist
#------------------------------------------------------------------------------




# &dump_lines();
# so46dad0673e25f.addVariable("url", "http%3A%2F%2Fwww.dailymotion.com%2Fget%2F13%2F320x240%2Fflv%2F1280968.flv%3Fkey%3Dab9a06c1fdb60fda72e47c6a3f20990512e5050");

if ( ($url) = $data =~ /"url",\s"([^"]+)"/g )
{
		$url =~ s/\%([A-Fa-f0-9]{2})/pack('C', hex($1))/seg;
		
      $item = $doc->createElement('item');
      $root->appendChild($item);
      
      $item->appendChild( newNode('name', "play: $sname") );
      $item->appendChild( newNode('url',  $url) );
      $item->appendChild( newNode('descr', "") );
      $item->appendChild( newNode('handler', "") );
}

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}



