#! /usr/bin/perl
#* ============================================================
# * File  : menu.pl
# * Author: Eric
# * Date  : 2006-09-29
# * Description: Shoutcast genre query
# *              http://www.shoutcast.com
# * Requires mythstream v0.17_2
# * 
# * == Use with stream item values below ==
# * STREAM URL    : http://www.shoutcast.com
# * STREAM HANDLER: *shoutcast/menu
# * 
# * ============================================================ */

 
    
use English;
use XML::Simple;
use XML::DOM;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

my $stage  = 0;  # menu level
my $choice = "";  # choice in last menu
my $path   = "";  # | separated values based on previous choices

sub decodeFakeURL
{
  local $url  = shift;    # fake url: http://fake#[stage]#[path]#[choice]

	# remove quotes if any
  $url =~ s/^\"?(.*?)\"?$/$1/;
  
  $url = substr($url, 7);
  ($fake, $stage, $path, $choice) = split('#', $url);

  if ($fake ne 'fake')
  {
    $stage  = 0;
    $choice = "";
    $path   = "";
  }

}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

  &read_parse();    # get commandline parameters into @in
  
  @alph      = split( / */, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  $urlPrefix = "http://fake";
  
  $source = $in[0]; # source filename from command line
  $url    = $in[1];
  decodeFakeURL($url); # get stage, path and choice
  

  if ($stage == 0)
  {
  
    open( FD, "<shoutcast/genres.txt" );
    @list = <FD>;
    close FD;
  
    foreach $line (@list)
    {
      ($id, $genre) = split(',', $line);
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , "Shoutcast $genre") );
      $item->appendChild( newNode('url'  , "$urlPrefix#1#$id#") );
      $item->appendChild( newNode('descr', 'Select ' . $genre ) );
      $item->appendChild( newNode('handler', '*shoutcast/menu' ) );
    }

  }
  elsif ($stage == 1)
  {
    $urlbase = 'http://www.shoutcast.com/directory/?sgenre=';

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , "Shoutcast $path") );
    $item->appendChild( newNode('url'  , $urlbase . $path) );
    $item->appendChild( newNode('descr', 'Shoutcast genre $path' ) );
    $item->appendChild( newNode('handler', 'shoutcast/shoutcast' ) );
  }
  
print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


