#! /usr/bin/perl
#* ============================================================
# * File  : example.pl
# * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
# * Date  : 2004-10-31
# * Description : XML stream list parser for streamtuned / mythstream
# * ============================================================ */

#This example script parses the following XML:
#
#<?xml version="1.0" encoding="iso-8859-1" ?>
#<!--
#- Database: `mythconverg`
#-->
#<mythconverg>
# <!-- Table streams -->
#  <streams>
#    <folder>TV</folder>
#    <server_name>KCMO News - Kansas City</server_name>
#    <url>http://www.kcmo.org/ch2.ram</url>
#    <description></description>
#  </streams>
#  <streams>
#    <folder>TV</folder>
#    <server_name>NASA</server_name>
#    <url>rtsp://163.205.10.22:8080/broadcast/ksc1/redundant/nasatv.rm</url>
#    <description></description>
#  </streams>
#  
    
    
use English;
use XML::Simple;
use XML::DOM;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

# filtering unescaped & 
$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$fdata = <INFO>;                 # Read all
close(INFO);
$fdata =~ s/&(amp;){0}/&amp;/g;

eval{ $data = $xml->XMLin($fdata, ForceArray => 1); };


foreach my $entry (@{$data->{Channels}})
{ 
    $descr = "";
    $descr = $entry->{Program_x0020_Name}->[0] . "";
    if ($descr eq "" ) {$descr = "[emptystring]"; }
    
    $item = $doc->createElement('item');
    $root->appendChild($item);

    $item->appendChild( newNode('name' , $entry->{Channel_Name}->[0]) );
    $item->appendChild( newNode('url'  , $entry->{Channel_x0020_URL}->[0]) );
    $item->appendChild( newNode('descr', $descr) );

    $node = 'Action: mark as nonfunctional';
    $meta = $doc->createElement('meta');
    $meta->appendChild( newNode('name'   , $node) );
    $meta->appendChild( newNode('content', $node) );
    $meta->appendChild( newNode('viewer' , 'url') );
    $item->appendChild( $meta );

}


print $head->toString;
print $root->toString;
print "\n";


# (myth)stream(tuned) expects the following xml output (descr, handler, meta nodes are optional)
# 
# <items>
#   <item>
#      <name>stream name</name>
#      <url>stream url</url>
#      <descr>stream description</descr>                      
#      <handler>handling hint* or parser script name</handler>   
#      <meta>                                                      
#         <name>meta data name</name>
#         <content>the meta data</content>
#         <viewer>viewer*</viewer>
#      </meta>
#      <meta>                                                
#         <name>meta data name</name>
#         <content></content>
#         <viewer></viewer>
#      </meta>
#      ...
#   </item>
#   <item>
#      <name>stream name</name>
#      <url>stream url</url>
#      <descr>stream description</descr>                    
#      <handler></handler>   
#   </item>
#   ...
# </items>  

# *handling hint: STREAM_* (e.g. STREAM_DL starts file download)
# * vieuwer: text, html, url

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


