/* OGMDvd - A wrapper library around libdvdread
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ogmdvd-priv.h"

#include <stdio.h>
#include <string.h>

#if DVDREAD_VERSION < 905
unsigned int UDFFindFile (dvd_reader_t *, const char *, unsigned int *);
#endif /* DVDREAD_VERSION */

gint64
_ogmdvd_get_ifo_size (OGMDvdDisc *disc, guint vts)
{
#if DVDREAD_VERSION >= 905
  dvd_file_t *file;
  gint size;

  file = DVDOpenFile (disc->reader, vts, DVD_READ_INFO_FILE);
  size = DVDFileSize (file);
  DVDCloseFile (file);

  size *= DVD_VIDEO_LB_LEN;
#else /* DVDREAD_VERSION */
  gchar filename[FILENAME_MAX];
  guint size;

  if (vts == 0)
    strncpy (filename, "/VIDEO_TS/VIDEO_TS.IFO", FILENAME_MAX);
  else
    snprintf (filename, FILENAME_MAX, "/VIDEO_TS/VTS_%02u_0.IFO", vts);

  if (!UDFFindFile (disc->reader, filename, &size))
    return -1;
#endif /* DVDREAD_VERSION */

  if (size < 0)
    return 0;

  return (gint64) size;
}

gint64
_ogmdvd_get_bup_size (OGMDvdDisc *disc, guint vts)
{
#if DVDREAD_VERSION >= 905
  dvd_file_t *file;
  gint size;

  file = DVDOpenFile (disc->reader, vts, DVD_READ_INFO_BACKUP_FILE);
  size = DVDFileSize (file);
  DVDCloseFile (file);

  size *= DVD_VIDEO_LB_LEN;
#else /* DVDREAD_VERSION */
  gchar filename[FILENAME_MAX];
  guint size;

  if (vts == 0)
    strncpy (filename, "/VIDEO_TS/VIDEO_TS.BUP", FILENAME_MAX);
  else
    snprintf (filename, FILENAME_MAX, "/VIDEO_TS/VTS_%02u_0.BUP", vts);

  if (!UDFFindFile (disc->reader, filename, &size))
    return 0;
#endif /* DVDREAD_VERSION */

  if (size < 0)
    return 0;

  return (gint64) size;
}

gint64
_ogmdvd_get_menu_size (OGMDvdDisc *disc, guint vts)
{
#if DVDREAD_VERSION >= 905
  dvd_file_t *file;
  gint size;

  file = DVDOpenFile (disc->reader, vts, DVD_READ_MENU_VOBS);
  size = DVDFileSize (file);
  DVDCloseFile (file);

  size *= DVD_VIDEO_LB_LEN;
#else /* DVDREAD_VERSION */
  gchar filename[FILENAME_MAX];
  guint size;

  if (vts == 0)
    strncpy (filename, "/VIDEO_TS/VIDEO_TS.VOB", FILENAME_MAX);
  else
    snprintf (filename, FILENAME_MAX, "/VIDEO_TS/VTS_%02u_0.VOB", vts);

  if (!UDFFindFile (disc->reader, filename, &size))
    return 0;
#endif /* DVDREAD_VERSION */

  if (size < 0)
    return 0;

  return (gint64) size;
}

gint64
_ogmdvd_get_vob_size (OGMDvdDisc *disc, guint vts)
{
  gint64 fullsize;

#if DVDREAD_VERSION >= 905
  dvd_file_t *file;

  file = DVDOpenFile (disc->reader, vts, DVD_READ_TITLE_VOBS);
  fullsize = DVDFileSize (file);
  DVDCloseFile (file);

  fullsize *= DVD_VIDEO_LB_LEN;
#else /* DVDREAD_VERSION */
  gchar filename[FILENAME_MAX];
  guint vob, size;

  if (vts == 0)
    return 0;

  vob = 1; fullsize = 0;
  while (1)
  {
    snprintf (filename, FILENAME_MAX, "/VIDEO_TS/VTS_%02u_%u.VOB", vts, vob++);
    if (!UDFFindFile (disc->reader, filename, &size))
      break;
    fullsize += size;
  }

  if (vob == 1)
    return 0;
#endif /* DVDREAD_VERSION */

  if (fullsize < 0)
    return 0;

  return fullsize;
}

