/*
**  MMUMappings.c
**
**	This file is subject to the terms and conditions of the GNU General Public
**	License.  See the file COPYING in the main directory of this archive
**	for more details.
**
*/

#include "MMU.h"

/* globals */
MemoryMappings		gMemoryMappings;

/*
 *	recordMemoryMapping
 *
 */
void recordMemoryMapping (
	u32 logAddr, 
	u32 physAddr, 
	u32 length,
	u32 attr)
{
	int		i, j, N;
	u32		lastPhysAddr, nextPhysAddr;
#if 0
	cprintf ("Recording %0.8X [ %0.2X : %0.2X : %0.2X ] -> %0.8X for %0.8X bytes\n", 
			logAddr, 
			BITS(gtia-1,0) & (logAddr >> (32 - gtia)), 
			BITS(gtib-1,0) & (logAddr >> (32 - gtia - gtib)), 
			BITS(gtic-1,0) & (logAddr >> (32 - gtia - gtib - gtic)), 
			physAddr, length);
#endif
	
	/*	Find where we want to insert this mapping
	 *	Typically, you would choose 
	 */
	N = gMemoryMappings.index;
	for (i = 0; i < N; i++)
	{
		if (logAddr < gMemoryMappings.log2phys[i].logical)
		{
			break;
		}
		
		if (logAddr == gMemoryMappings.log2phys[i].logical)
		{
			/*	Mapping already exists ... no need to do over
			 */
			return;
		}
	}
	
	/*	Check to see if two "RAM" address ranges can be coalesced
	 */
	if (logAddr < 0x40000000 && physAddr != NOT_MAPPED)
	{
		if (i > 0)
		{
			unsigned long lastLogAddr, lastLength;
			
			lastLogAddr = gMemoryMappings.log2phys[i-1].logical;
			lastLength = gMemoryMappings.log2phys[i-1].length;
			lastPhysAddr = gMemoryMappings.log2phys[i-1].physical;
			
			if (lastLogAddr + lastLength == logAddr &&
			    lastPhysAddr + lastLength == physAddr)
			{
				gMemoryMappings.log2phys[i-1].length += length;
				return;
			}
		}
	}
	
	/*	Check to see if two "not mapped" address ranges can be coalesced
	 */
	if (physAddr == NOT_MAPPED)
	{
		if (i > 0)	lastPhysAddr = gMemoryMappings.log2phys[i-1].physical;
		else		lastPhysAddr = 0;

		if (i < N)	nextPhysAddr = gMemoryMappings.log2phys[i+1].physical;
		else		nextPhysAddr = 0;


		if (lastPhysAddr == NOT_MAPPED)
		{
			gMemoryMappings.log2phys[i-1].length += length;
			return;
		}

		if (nextPhysAddr == NOT_MAPPED)
		{
			gMemoryMappings.log2phys[i+1].length += length;
			return;
		}
	}

	/*	Make room for the new mapping
	 */
	for (j = N; j > i; j--)
	{
		gMemoryMappings.log2phys[j] = gMemoryMappings.log2phys[j-1];
	}
	
	/*	Put the mapping into place
	 */
	gMemoryMappings.log2phys[i].logical = logAddr;
	gMemoryMappings.log2phys[i].physical = physAddr;
	gMemoryMappings.log2phys[i].length = length;
	gMemoryMappings.log2phys[i].attr = attr;
	
	/*	Mapping insertion complete
	 */
	gMemoryMappings.index += 1;
}
