#############################################################################
# ui.pm extension file, included from the puic-generated form implementation.
# If you wish to add, delete or rename signals or slots use
# the Perl-enabled Qt Designer which will update this file,
# preserving your code.
#
# 'SLOT:' markers are not meant to be created or edited manually.
# Please use the Slots dialog and/or the Object Browser.
#############################################################################


sub init
{
  my $hl = Qt::HBoxLayout ();
  my $sv = Qt::ScrollView (this, "menu_display_scroll_view");
  my $md = MenuDisplay ($sv -> viewport (), "menu_display", this);

  layout () -> insertLayout (0, $hl, 1);
  $hl       -> addWidget ($sv);
  $sv       -> addChild ($md);

  scroll_view  = $sv;
  menu_display = $md;
}


sub destroy
{
#  print STDERR "MenuPreview::destroy\n";

  menu_display = undef;
  scroll_view  = undef;
  main_window  = undef;
  background   = undef;
  base         = undef;
  hilited      = undef;
  selected     = undef;
  button_geos  = undef;
}


sub remove_all
{
  menu_display = undef;
  scroll_view  = undef;
  main_window  = undef;
  background   = undef;
  base         = undef;
  hilited      = undef;
  selected     = undef;
  button_geos  = undef;
}


# figure out width and height of text drawn with font
sub text_bounds
{
  my $font = shift;
  my $text = shift;

  my $pm = Qt::Pixmap (1, 1);
  my $p  = Qt::Painter ($pm);
  $p -> setFont ($font);

  return $p -> boundingRect (0, 0, 0, 0, 0, $text);
}


# find the maximum height of texts drawn with font
sub max_text_height
{
  my $font  = shift;
  my $texts = shift;

  my $rv = 0;

  for my $t (@{$texts})
  {
    my $h = text_bounds ($font, $t) -> height ();

    $rv = $h if ($h > $rv);
  }

  return $rv;
}


sub draw_transparent_text
{
  my $pm    = shift;
  my $font  = shift;
  my $color = shift;
  my $x     = shift;
  my $y     = shift;
  my $text  = shift;

  # create bitmap of same size as destination pixmap
  my $bm = Qt::Bitmap ($pm -> size (), 1);

  # print text to bitmap
  my $p  = Qt::Painter ($bm);
  my $br = Qt::Rect;
  $p -> setFont ($font);
  $p -> setPen (&Qt::color1);
  $p -> drawText (Qt::Rect ($x, $y, 0, 0),
		  &Qt::AlignLeft |&Qt::AlignTop|
		  &Qt::SingleLine|&Qt::DontClip,
		  $text, -1, $br);

  my $w = $br -> width ();
  my $h = $br -> height ();

  # make everything but the text transparent
  $bm -> setMask ($bm);

  # draw bitmap on destination pixmap in given color
  $p = Qt::Painter ($pm);
  $p -> setPen ($color);
  $p -> drawPixmap ($x, $y, $bm, $x, $y, $w, $h);

  # draw bitmap on mask of destination pixmap - this shouldn't really
  # be necessary as far as I understand, but anyway, it works like this
  $p = Qt::Painter ($pm -> mask ());
  $p -> drawPixmap ($x, $y, $bm, $x, $y, $w, $h);
}


sub generate
{
  my $main_window = shift;

  main_window = $main_window;

  my $top_margin     = read_setting ("/Menu/Spacing/top");
  my $heading_gap    = read_setting ("/Menu/Spacing/heading");
  my $subheading_gap = read_setting ("/Menu/Spacing/subheading");
  my $button_gap     = read_setting ("/Menu/Spacing/button");
  my $bottom_margin  = read_setting ("/Menu/Spacing/bottom");
  my $tv_standard    = read_setting ("/Menu/Preferences/tv_standard");

  my $heading_font =
    Qt::Font (@{read_list_setting ("/Menu/Fonts/heading")});
  my $subheading_font =
    Qt::Font (@{read_list_setting ("/Menu/Fonts/subheading")});
  my $button_font =
    Qt::Font (@{read_list_setting ("/Menu/Fonts/buttons")});

  my $heading_color =
    Qt::Color (@{read_list_setting ("/Menu/Colors/heading")});
  my $subheading_color =
    Qt::Color (@{read_list_setting ("/Menu/Colors/subheading")});
  my $button_base_color =
    Qt::Color (@{read_list_setting ("/Menu/Colors/button_base")});
  my $button_hilited_color =
    Qt::Color (@{read_list_setting ("/Menu/Colors/button_hilited")});
  my $button_selected_color =
    Qt::Color (@{read_list_setting ("/Menu/Colors/button_selected")});

  my $width  = 720;
  my $height = 480;

  $height = 576 if ($tv_standard ne "NTSC");

  my $bg_filename = $main_window -> background_filename ();
  my $background  = Qt::Image ($bg_filename);

  if ($background -> isNull ())
  {
    $background -> create ($width, $height, 32);
    $background -> fill (0);

    write_setting ("/Menu/Preferences/background", $bg_filename)
      if ($bg_filename =~ /\.mpe?g$/ && stat ($bg_filename) != 0);
  }
  else
  {
    if ($background -> width ()  != $width ||
	$background -> height () != $height)
    {
      $background = $background -> smoothScale ($width, $height,
						&Qt::Image::ScaleMax);

      my $x = ($background -> width ()  - $width)  / 2;
      my $y = ($background -> height () - $height) / 2;

      $background = $background -> copy ($x, $y, $width, $height);
    }

    write_setting ("/Menu/Preferences/background", $bg_filename);
  }

  background = $background;

  my $base     = Qt::Pixmap ($width, $height);
  my $hilited  = Qt::Pixmap ($width, $height);
  my $selected = Qt::Pixmap ($width, $height);
  base         = $base;
  hilited      = $hilited;
  selected     = $selected;
  $base     -> setMask (Qt::Bitmap ($width, $height, 1));
  $hilited  -> setMask (Qt::Bitmap ($width, $height, 1));
  $selected -> setMask (Qt::Bitmap ($width, $height, 1));

  # draw heading on base image
  my $heading = $main_window -> heading ();
  my $bounds  = text_bounds ($heading_font, $heading);
  my $y       = $top_margin;
  my $x       = ($width - $bounds -> width ()) / 2;

  draw_transparent_text ($base, $heading_font,
			 $heading_color, $x, $y, $heading);

  $y += $heading_gap + $bounds -> height ();

  # draw subheading on base image
  my $subheading = $main_window -> subheading ();
  $bounds        = text_bounds ($subheading_font, $subheading);
  $x             = ($width - $bounds -> width ()) / 2;

  draw_transparent_text ($base, $subheading_font,
			 $subheading_color, $x, $y, $subheading);

  $y += $subheading_gap + $bounds -> height ();

  my $button_text;
  my @button_texts;
  my $table_items = $main_window -> menu_table_items ();

  for (my $row = 0;
       defined ($button_text = $table_items -> menu_text ($row)); $row++)
  {
    push @button_texts, $button_text;
  }

  # calculate maximum button height
  my $button_height = max_text_height ($button_font, \@button_texts);

  # reduce button font size and gap if not all selections fit on screen
  my $btn_points = $button_font -> pointSizeFloat ();
  my $dppt       = Qt::PaintDeviceMetrics ($base) -> logicalDpiY () / 72.27;
  my $gap_points = $button_gap / $dppt;

#  print STDERR "dppt=$dppt\n";

  while (@button_texts * ($button_height + $button_gap) >=
	 $height - $bottom_margin - $y)
  {
    $btn_points -= 0.2 if ($btn_points > 4.0);
    $gap_points -= 0.2 if ($gap_points > 0.0);
    last           unless ($btn_points > 4.0 || $gap_points > 0.0);

    $button_font -> setPointSizeFloat ($btn_points);
    $button_height = max_text_height ($button_font, \@button_texts);
    $button_gap    = sprintf "%d", $gap_points * $dppt;
  }

  my @button_geos;
  button_geos = \@button_geos;

  # draw the menu buttons
  for my $text (@button_texts)
  {
    $bounds = text_bounds ($button_font, $text);
    $x      = ($width - $bounds -> width ()) / 2;

    # save button corner coordinates appropriate for use with spumux
    push @button_geos,
         Qt::Rect ($x, $y, $bounds -> width (), $button_height);

    # draw text on base image
    draw_transparent_text ($base, $button_font,
			   $button_base_color, $x, $y, $text);

    # draw text on highlight image
    draw_transparent_text ($hilited, $button_font,
			   $button_hilited_color, $x, $y, $text);

    # draw text on select image
    draw_transparent_text ($selected, $button_font,
			   $button_selected_color, $x, $y, $text);

    $y += $button_height + $button_gap;
  }
}


sub preview
{
  my $main_window = shift;

  $main_window -> menu_table_items () -> end_edit_mode ();

  generate ($main_window);

  my $sv = scroll_view;
  my $md = menu_display;

  $md -> preview (background);
  $sv -> setMaximumSize ($md -> width ()  + 2 * $sv -> lineWidth (),
			 $md -> height () + 2 * $sv -> lineWidth ());

  if (isHidden ())
  {
    my $min_size = $sv -> minimumSize ();
    $sv -> setMinimumSize ($sv -> maximumSize ());
    adjustSize ();
    $sv -> setMinimumSize ($min_size);
  }
}


sub update_view
{
  my $main_window = main_window;

  $main_window -> menu_table_items () -> update ();
  preview ($main_window);
  setActiveWindow ();
}


sub background_image
{
  return background;
}


sub base_pixmap
{
  return base;
}


sub hilited_pixmap
{
  return hilited;
}


sub selected_pixmap
{
  return selected;
}


sub button_geometries
{
  return button_geos;
}
