/* sockets.h: this file is the header file for the tlm socket function
 *   library
 *
 *  Version: 2.10f
 *	Authors: Dr. Charles E. Campbell, GSFC/NASA
 *           Terry McRoberts, GSFC/NASA
 */
#ifndef _INC_SOCKFUNC_H
#define _INC_SOCKFUNC_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

/* --------------------------------------------------------------------------
 * Definitions Section
 */

#define PM_BIGBUF			1024
#define PM_MAXTRY			20	/* max number of resends to PortMaster	*/
#define PM_MAXREQUESTS		10	/* max pending connects					*/

/* socket types: (SFSocket::type) */
#define PM_SERVER	((u_short) 1)
#define PM_CLIENT	((u_short) 2)
#define PM_ACCEPT	((u_short) 8)

/* --------------------------------------------------------------------------
 * Typedef Section
 */
typedef unsigned short		u_short; 
typedef struct Skt_str		SFSocket;
typedef u_short				SKTEVENT;

/* --------------------------------------------------------------------------
 * Data Structures:
 */
struct Skt_str {
	int      skt;		/* skt handle						*/
	SKTEVENT port;		/* associated port					*/
	int      type;		/* PM_SERVER, PM_CLIENT, PM_ACCEPT	*/
	char    *sktname;	/* name of socket					*/
	char    *hostname;	/* name of host						*/
};

/* --------------------------------------------------------------------------
 * Prototypes:
 */
void Sinit(void);                                        /* Sinit.c         */
SFSocket *makeSocket(const char *,const char *,int);     /* Smkskt.c        */
void freeSocket(SFSocket *);                             /* Smkskt.c        */
SFSocket *Sopen_server(u_short port); 
SFSocket *Sopen_client(const char *server, u_short port); 
SFSocket *Saccept(SFSocket *);                           /* Saccept.c       */
void Sclose(SFSocket *);                                 /* Sclose.c        */
unsigned long Speeraddr(SFSocket *);                     /* Speeraddr.c     */
char *Speername(SFSocket *);                             /* Speername.c     */
int Sread( SFSocket *,  void *,  int);                   /* Sread.c         */
int Sreadbytes( SFSocket *,  void *,  int);              /* Sreadbytes.c    */
int Stest(SFSocket *);                                   /* Stest.c         */
int Stimeoutwait(SFSocket *,long,long);                  /* Stimeoutwait.c  */
int Swrite( SFSocket *,  void *,  int);                  /* Swrite.c        */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef SOCKETS_H */
