/*
 * inirepdata.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __WXX_INI_REPORT_DATA_H__
#define __WXX_INI_REPORT_DATA_H__

#include "reportdata.h"

class wxxIniFile;
class wxxIniSection;

enum wxxIniSortMode
{
	wxREPORT_SORTSTRING,
	wxREPORT_SORTSTRING_NOCASE,
	wxREPORT_SORTNUMERIC
};

class wxxIniColumnInfo : public wxxReportColumnInfo
{
public:
	wxxIniColumnInfo(const wxString& title, const wxString& field, int width, wxxReportTextAlign align = wxREPORT_LEFT,
		wxxIniSortMode sortmode = wxREPORT_SORTSTRING_NOCASE) : wxxReportColumnInfo(title, width, align), 
		field(field), sortmode(sortmode) {}
	~wxxIniColumnInfo() {}

	wxString field;
	wxxIniSortMode sortmode;
};

class wxxIniReportData : public wxxReportData  
{
public:
	wxxIniReportData(const wxString& iniFile, int colCount, const wxxIniColumnInfo** infos, 
		wxxReportDeleteMode delInfos = wxREPORT_DELELEMENTS);

	int GetRowCount();
	wxString GetRowName(long row); // gets the section name for that row
	wxString GetItemText(long row, int col);
	int CompareItems(long row1, long row2);
	// Refreshes the section cache
	// Returns true if it has changed (you should then call DoLines())
	virtual bool DoSectionCache();
	virtual bool Reload(); // Reloads the entire file

	wxxIniReportData();
	~wxxIniReportData();

	/// If initialized is false, translates the titles of the passed-in column infos
	/// and sets initialized to true. Otherwise, does nothing. 
	/// @return The initialized infos. (same as the passed-in infos)
	static const wxxIniColumnInfo** InitColumnInfo(wxxIniColumnInfo** infos, int count, bool& initialized); 
	
protected:
	wxxIniSection** sectionCache;
	int numSections;
	wxxIniFile* ini;
	wxString iniFile;

private:
};

#endif
