/*
 * robstrings.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/** @file robstrings.h
  * Includes most string constants in RoboTour.
  * For easier translation.
  */

#ifndef __RT_ROBSTRINGS__
#define __RT_ROBSTRINGS__

namespace lrt {
	class String; 
}

#include "robvars.h"

namespace rt {

/// Names of the simulation variables (Simulation::vars).
/// These cannot, and must not, be translated. 
extern const char* simVarNames[];
/// Names of the program variables (Program::vars).
/// These cannot, and must not, be translated. 
extern const char* progVarNames[];
/// Names of the robot variables (Bot::vars).
/// These cannot, and must not, be translated. 
extern const char* botVarNames[];
/// Names of the task variables (Task::vars).
/// These cannot, and must not, be translated. 
extern const char* taskVarNames[];

/** Bot::exec() failure codes (translated).
  * @see ExecReturnType */
lrt::String getFailMsg(ExecReturnType);

/** RobLoader::load() fail codes (translated).
  * @see RobLoadReturnType */
lrt::String getRobLoadFailMsg(RobLoadReturnType); 

/** RbiLoader::load() fail codes. Leave first one empty.
  * @see RbiLoadReturnType */
lrt::String getRbiLoadFailMsg(RbiLoadReturnType); 

/** Generic ProgramLoader::loadXxx() failure codes. 
  * @see GenLoadFailType
  */
lrt::String getGenLoadFailMsg(GenLoadFailType); 

} // namespace

#endif

