/*
 * robwxext.h
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#ifndef __RT_WX_CLASSEX__
#define __RT_WX_CLASSEX__

// Contains some small extension classes for wxWidgets. 

#include <wx/listctrl.h>
#include <wx/splitter.h>

class ImprovedListCtrl : public wxListCtrl {
public:
	ImprovedListCtrl(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, long style = wxLC_ICON, 
		const wxValidator& validator = wxDefaultValidator, const wxString& name = wxT("listCtrl"));
	void SetGrowableCol(int col);

	DECLARE_EVENT_TABLE()
private:
	void OnSize(wxSizeEvent&);

	int growableCol;
};

class ImprovedSplitter : public wxSplitterWindow {
public:
	ImprovedSplitter(wxWindow* parent, wxWindowID id, const wxPoint& point = wxDefaultPosition, 
		const wxSize& size = wxDefaultSize, long style=wxSP_3D, const wxString& name = wxT("splitterWindow"));

	DECLARE_EVENT_TABLE()
private:
	void OnErase(wxEraseEvent&);
};

template <class W> class NoFlickerWindow : public W {
public:
	NoFlickerWindow() 
	{
		this->Connect(-1, wxEVT_ERASE_BACKGROUND, (wxObjectEventFunction) &NoFlickerWindow<W>::OnErase);
	}

private:
	void OnErase(wxEraseEvent&) { /* do nothing  */ }
};

#endif // file
