/**********************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.

  (c) Copyright 1996 - 2002  Gary Henderson (gary.henderson@ntlworld.com) and
                             Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2002 - 2004  Matthew Kendora

  (c) Copyright 2002 - 2005  Peter Bortas (peter@bortas.org)

  (c) Copyright 2004 - 2005  Joel Yliluoma (http://iki.fi/bisqwit/)

  (c) Copyright 2001 - 2006  John Weidman (jweidman@slip.net)

  (c) Copyright 2002 - 2006  Brad Jorsch (anomie@users.sourceforge.net),
                             funkyass (funkyass@spam.shaw.ca),
                             Kris Bleakley (codeviolation@hotmail.com),
                             Nach (n-a-c-h@users.sourceforge.net), and
                             zones (kasumitokoduck@yahoo.com)

  BS-X C emulator code
  (c) Copyright 2005 - 2006  Dreamer Nom,
                             zones

  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003  _Demo_ (_demo_@zsnes.com),
                             Nach,
                             zsKnight (zsknight@zsnes.com)

  C4 C++ code
  (c) Copyright 2003 - 2006  Brad Jorsch,
                             Nach

  DSP-1 emulator code
  (c) Copyright 1998 - 2006  _Demo_,
                             Andreas Naive (andreasnaive@gmail.com)
                             Gary Henderson,
                             Ivar (ivar@snes9x.com),
                             John Weidman,
                             Kris Bleakley,
                             Matthew Kendora,
                             Nach,
                             neviksti (neviksti@hotmail.com)

  DSP-2 emulator code
  (c) Copyright 2003         John Weidman,
                             Kris Bleakley,
                             Lord Nightmare (lord_nightmare@users.sourceforge.net),
                             Matthew Kendora,
                             neviksti


  DSP-3 emulator code
  (c) Copyright 2003 - 2006  John Weidman,
                             Kris Bleakley,
                             Lancer,
                             z80 gaiden

  DSP-4 emulator code
  (c) Copyright 2004 - 2006  Dreamer Nom,
                             John Weidman,
                             Kris Bleakley,
                             Nach,
                             z80 gaiden

  OBC1 emulator code
  (c) Copyright 2001 - 2004  zsKnight,
                             pagefault (pagefault@zsnes.com),
                             Kris Bleakley,
                             Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002         Matthew Kendora with research by
                             zsKnight,
                             John Weidman,
                             Dark Force

  S-DD1 C emulator code
  (c) Copyright 2003         Brad Jorsch with research by
                             Andreas Naive,
                             John Weidman

  S-RTC C emulator code
  (c) Copyright 2001-2006    byuu,
                             John Weidman

  ST010 C++ emulator code
  (c) Copyright 2003         Feather,
                             John Weidman,
                             Kris Bleakley,
                             Matthew Kendora

  Super FX x86 assembler emulator code
  (c) Copyright 1998 - 2003  _Demo_,
                             pagefault,
                             zsKnight,

  Super FX C emulator code
  (c) Copyright 1997 - 1999  Ivar,
                             Gary Henderson,
                             John Weidman

  Sound DSP emulator code is derived from SNEeSe and OpenSPC:
  (c) Copyright 1998 - 2003  Brad Martin
  (c) Copyright 1998 - 2006  Charles Bilyue'

  SH assembler code partly based on x86 assembler code
  (c) Copyright 2002 - 2004  Marcus Comstedt (marcus@mc.pp.se)

  2xSaI filter
  (c) Copyright 1999 - 2001  Derek Liauw Kie Fa

  HQ2x filter
  (c) Copyright 2003         Maxim Stepin (maxim@hiend3d.com)

  Specific ports contains the works of other authors. See headers in
  individual files.

  Snes9x homepage: http://www.snes9x.com

  Permission to use, copy, modify and/or distribute Snes9x in both binary
  and source form, for non-commercial purposes, is hereby granted without 
  fee, providing that this license information and copyright notice appear 
  with all copies and any derived work.

  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software or it's derivatives.

  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes,
  but is not limited to, charging money for Snes9x or software derived from
  Snes9x, including Snes9x or derivatives in commercial game bundles, and/or
  using Snes9x as a promotion for your commercial product.

  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.

  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
**********************************************************************************/


/*******************************************************************************
  SNES9X for Mac OS (c) Copyright John Stiles
  
  Snes9x for Mac OS X

  (c) Copyright 2001 - 2006 zones
  (c) Copyright 2002 - 2006 107
  (c) Copyright 2002        PB1400c
  (c) Copyright 2004        Alexander and Sander
  (c) Copyright 2004 - 2005 Steven Seeger
  (c) Copyright 2005        Ryan Vogt
*******************************************************************************/

#ifndef _mac_os_h_
#define _mac_os_h_

void InitGameWindow(void);
void DeinitGameWindow(void);
void UpdateGameWindow(void);
void AddRecentItem(FSRef *);
void BuildRecentMenu(void);
void EnableMenus(void);
void DisableMenus(void);
void QuitWithFatalError(OSStatus, const char *);
void ChangeInputDevice(void);
void GetGameScreenPointer(int16 *, int16 *, bool);
void PostQueueToSubEventLoop(void);
int PromptFreezeDefrost(Boolean);

enum
{
	kDrawingDirect = 1,
	kDrawingOpenGL,
	kDrawingBlitGL
};

enum
{
	kWindowControllers = 0,
	kWindowPreferences,
	kWindowAbout,
	kWindowAutoFire,
	kWindowMusicBox,
	kWindowRomInfo,
	kWindowCheatFinder,
	kWindowKeyConfig,
	kWindowCheatEntry,
	kWindowScreen,
	kWindowServer,
	kWindowClient,
	kWindowExtra,
	kWindowSoundEffect,
	kWindowCoreImageFilter,
	
	kWindowCount
};

enum
{
	SNES_MULTIPLAYER5,
	SNES_MULTIPLAYER5_2,
	SNES_JOYPAD,
	SNES_MOUSE_SWAPPED,
	SNES_MOUSE,
	SNES_SUPERSCOPE,
	SNES_JUSTIFIER,
	SNES_JUSTIFIER_2,
	SNES_MAX_CONTROLLER_OPTIONS
};

typedef struct
{
	long long	nextTime[12];
	uint16		buttonMask;
	uint16		toggleMask;
	uint16		tcMask;
	uint16		invertMask;
	SInt32		frequency;
}	AutoFireState;

typedef struct
{
	bool8	benchmark;
	bool8	glForceNoTextureRectangle;
	bool8	glUseClientStrageApple;
	bool8	glUseTexturePriority;
	int		glStorageHint;
}	ExtraOption;

#define kMacWindowHeight	(SNES_HEIGHT_EXTENDED << 1)
#define	MAC_MAX_PLAYERS		8

extern volatile bool8		running, s9xthreadrunning;
extern volatile bool8		eventQueued, windowExtend;
extern volatile int			windowResizeCount;
extern uint32				controlPad[MAC_MAX_PLAYERS];
extern uint8				romDetect, interleaveDetect, videoDetect, headerDetect;			
extern WindowRef			gWindow;
extern CGrafPtr				gWindowPort;
extern RgnHandle			gWindowRgn;
extern Rect					gWindowRect;
extern int					gWindowBarHeight;
extern int					glScreenW, glScreenH;
extern CGRect				glScreenBounds;
extern Point				windowPos[kWindowCount];
extern CGSize				windowSize[kWindowCount];
extern int					macFrameSkip;
extern int32				skipFrames;
extern int64				lastFrame;
extern unsigned long		spcFileCount, pngFileCount;
extern long					lastDrawingMethod;
extern long					systemVersion, qtVersion, hiToolboxVersion;
extern bool8				finished, cartOpen,
							autofire, hidExist, folderWarning, lockedROMMedia, directDisplay;
extern bool8				fullscreen, autoRes, doubleSize,
							tvMode, smoothMode, eagleMode, saiMode, supsaiMode, epxMode, hq2xMode,
							glstretch, gl32bit, vsync, drawoverscan, lastoverscan, screencurvature,
							multiprocessor, ciFilterEnable;
extern long					drawingMethod;
extern float				macSoundPitch, macSoundPitchMaster;
extern SInt32				macSoundVolume;
extern int					macSoundInterval;
extern uint16				aueffect;
extern uint8				saveInROMFolder;
extern int					mac7110Load, mac7110Megs, macSDD1Pack;
extern int					macCurvatureWarp, macAspectRatio;
extern int					macFastForwardRate;
extern int					inactiveMode;
extern bool8				macQTRecord;
extern uint16				macRecordFlag, macPlayFlag, macQTMovFlag;
extern bool8				startopendlog, showtimeinfrz, enabletoggle,
							savewindowpos, onscreeninfo, minimizecpu;
extern int					musicboxmode;
extern bool8				applycheat;
extern int					padSetting, deviceSetting;
extern int					macControllerOption;
extern CGPoint				unlimitedCursor;
extern char					npServerIP[256], npName[256];
extern AutoFireState		autofireRec[MAC_MAX_PLAYERS];
extern ExtraOption			extraOptions;

#endif
