/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class ImageDescriptorRegistry {
    private HashMap registry = new HashMap(10);
    private Display display;

    public ImageDescriptorRegistry() {
        this(SpringUIUtils.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.display = display;
        Assert.isNotNull((Object)display);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.registry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.display == SpringUIUtils.getStandardDisplay() ? 1 : 0) != 0, (String)"Allocating image for wrong display.");
        result = descriptor.createImage();
        if (result != null) {
            this.registry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.registry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.registry.clear();
    }

    private void hookDisplay() {
        this.display.disposeExec(new Runnable(){

            public void run() {
                ImageDescriptorRegistry.this.dispose();
            }
        });
    }
}

