/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ConstructorArgumentNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;
import org.springframework.ide.eclipse.beans.ui.model.RootNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;

public abstract class AbstractNode
implements INode {
    private INode parent;
    private String name;
    private IModelElement element;
    private int flags;
    private int startLine;

    public AbstractNode(String name) {
        this(null, name);
    }

    public AbstractNode(INode parent, String name) {
        this.parent = parent;
        this.name = name;
        this.flags = 0;
        this.startLine = -1;
    }

    public INode getParent() {
        return this.parent;
    }

    public final void setParent(INode parent) {
        this.parent = parent;
    }

    public final INode[] getChildren() {
        if (this instanceof RootNode) {
            return ((RootNode)this).getProjects();
        }
        if (this instanceof ProjectNode) {
            ProjectNode project = (ProjectNode)this;
            List nodes = project.getConfigs();
            nodes.addAll(project.getConfigSets());
            return nodes.toArray(new INode[nodes.size()]);
        }
        if (this instanceof ConfigSetNode) {
            return ((ConfigSetNode)this).getBeans(true);
        }
        if (this instanceof ConfigNode) {
            return ((ConfigNode)this).getBeans(true);
        }
        if (this instanceof BeanNode) {
            BeanNode bean = (BeanNode)this;
            ArrayList<ConstructorArgumentNode> nodes = new ArrayList<ConstructorArgumentNode>(Arrays.asList(bean.getConstructorArguments()));
            nodes.addAll(Arrays.asList(bean.getProperties()));
            return nodes.toArray(new INode[nodes.size()]);
        }
        return NO_CHILDREN;
    }

    public final boolean hasChildren() {
        return !(this instanceof PropertyNode) && !(this instanceof ConstructorArgumentNode);
    }

    public final String getID() {
        StringBuffer id = new StringBuffer();
        if (this.getParent() != null) {
            id.append(this.getParent().getID());
            id.append('|');
        }
        if (this.getElement() != null) {
            id.append(this.getElement().getElementType());
        }
        id.append(':');
        if (this.getName() != null) {
            id.append(this.getName());
        } else {
            id.append(this.hashCode());
        }
        return id.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final void setElement(IModelElement element) {
        this.element = element;
        this.startLine = element instanceof ISourceModelElement ? ((ISourceModelElement)element).getElementStartLine() : -1;
    }

    public final IModelElement getElement() {
        return this.element;
    }

    public final void setFlags(int flags) {
        this.flags |= flags;
        flags &= 0xFFFFFF86;
        if (this.parent != null && this.parent instanceof AbstractNode) {
            ((AbstractNode)this.parent).setFlags(flags);
        }
    }

    public final void clearFlags(int flags) {
        this.flags &= ~flags;
        if (this.parent != null && this.parent instanceof AbstractNode) {
            ((AbstractNode)this.parent).clearFlags(flags);
        }
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public final int getStartLine() {
        return this.startLine;
    }

    public final INode getNode(String id) {
        IModelElement element = this.getElement();
        int sepPos = id.indexOf(58);
        if (element != null && sepPos > 0) {
            try {
                int type = Integer.valueOf(id.substring(0, sepPos));
                if (type == element.getElementType()) {
                    int delPos = id.indexOf(124);
                    if (delPos > 0) {
                        String name = id.substring(sepPos + 1, delPos);
                        if (name.equals(element.getElementName())) {
                            id = id.substring(delPos + 1);
                            INode[] children = this.getChildren();
                            int i = 0;
                            while (i < children.length) {
                                INode node;
                                INode child = children[i];
                                if (child instanceof AbstractNode && (node = ((AbstractNode)child).getNode(id)) != null) {
                                    return node;
                                }
                                ++i;
                            }
                        }
                    } else {
                        String name = id.substring(sepPos + 1);
                        if (name.equals(element.getElementName())) {
                            return this;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public void propertyChanged(INode node, int propertyId) {
        AbstractNode parent = (AbstractNode)this.getParent();
        if (parent != null) {
            parent.propertyChanged(node, propertyId);
        }
    }

    public void refreshViewer() {
        if (this.parent != null && this.parent instanceof AbstractNode) {
            ((AbstractNode)this.parent).refreshViewer();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String toString() {
        return this.name;
    }
}

