/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.properties.FileFilter;
import org.springframework.ide.eclipse.beans.ui.properties.FileSelectionValidator;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class ConfigFilesBlock {
    private static final int TABLE_WIDTH = 250;
    private static final String DESCRIPTION = "ConfigurationPropertyPage.tabConfigFiles.description";
    private static final String ADD_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.addButton";
    private static final String REMOVE_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.removeButton";
    private static final String DIALOG_TITLE = "ConfigurationPropertyPage.tabConfigFiles.addConfigDialog.title";
    private static final String DIALOG_MESSAGE = "ConfigurationPropertyPage.tabConfigFiles.addConfigDialog.message";
    private ProjectNode project;
    private IAdaptable element;
    private Table configsTable;
    private TableViewer configsViewer;
    private Button addButton;
    private Button removeButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ConfigFilesBlock.this.handleButtonPressed((Button)e.widget);
        }
    };
    private IPropertyListener propertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            ConfigFilesBlock.this.handlePropertyChanged(source, propId);
        }
    };
    private boolean hasUserMadeChanges;

    public ConfigFilesBlock(ProjectNode project, IAdaptable element) {
        this.project = project;
        this.element = element;
        this.project.addPropertyListener(this.propertyListener);
    }

    public boolean hasUserMadeChanges() {
        return this.hasUserMadeChanges;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label description = new Label(composite, 64);
        description.setText(BeansUIPlugin.getResourceString(DESCRIPTION));
        description.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite(composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        this.configsTable.setLayoutData((Object)data);
        this.configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigFilesBlock.this.handleTableSelectionChanged();
            }
        });
        this.configsViewer = new TableViewer(this.configsTable);
        this.configsViewer.setContentProvider((IContentProvider)new ConfigFilesContentProvider(this.project));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        this.configsViewer.setInput((Object)this);
        this.configsViewer.setSorter((ViewerSorter)new ConfigFilesSorter());
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(ADD_BUTTON), (boolean)true, (SelectionListener)this.buttonListener);
        this.removeButton = SpringUIUtils.createButton((Composite)buttonArea, (String)BeansUIPlugin.getResourceString(REMOVE_BUTTON), (boolean)false, (SelectionListener)this.buttonListener);
        return composite;
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    private void handleButtonPressed(Button button) {
        if (button == this.addButton) {
            this.handleAddButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        }
        this.handleTableSelectionChanged();
        this.configsTable.setFocus();
    }

    private void handleAddButtonPressed() {
        Object[] selection;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(BeansUIPlugin.getResourceString(DIALOG_TITLE));
        dialog.setMessage(BeansUIPlugin.getResourceString(DIALOG_MESSAGE));
        dialog.addFilter((ViewerFilter)new FileFilter(new String[]{"xml"}));
        dialog.setValidator((ISelectionStatusValidator)new FileSelectionValidator(true));
        dialog.setInput((Object)this.element);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            int i = 0;
            while (i < selection.length) {
                IFile file = (IFile)selection[i];
                String config = file.getProjectRelativePath().toString();
                this.project.addConfig(config);
                ++i;
            }
            this.hasUserMadeChanges = true;
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator elements = selection.iterator();
            while (elements.hasNext()) {
                ConfigNode node = (ConfigNode)elements.next();
                this.project.removeConfig(node.getName());
            }
            this.hasUserMadeChanges = true;
        }
    }

    private void handlePropertyChanged(Object source, int propId) {
        if (this.configsViewer != null && !this.configsViewer.getControl().isDisposed()) {
            this.configsViewer.refresh();
        }
    }

    public void dispose() {
        this.project.removePropertyListener(this.propertyListener);
    }

    private class ConfigFilesContentProvider
    implements IStructuredContentProvider {
        private ProjectNode project;

        public ConfigFilesContentProvider(ProjectNode project) {
            this.project = project;
        }

        public Object[] getElements(Object obj) {
            return this.project.getConfigs().toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public void dispose() {
        }
    }

    private class ConfigFilesSorter
    extends ViewerSorter {
        public static final int SUB_DIR = 0;
        public static final int ROOT_DIR = 1;

        ConfigFilesSorter() {
        }

        public int category(Object element) {
            return ((ConfigNode)element).getName().indexOf(47) == -1 ? 1 : 0;
        }
    }
}

