/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.project;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescription;
import org.springframework.ide.eclipse.beans.core.internal.project.IBeansProjectDescriptionConstants;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.core.io.xml.XMLWriter;

public class BeansProjectDescriptionWriter
implements IBeansProjectDescriptionConstants {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/project/description/debug";
    public static boolean DEBUG = BeansCorePlugin.isDebug("org.springframework.ide.eclipse.beans.core/project/description/debug");

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void write(IProject project, BeansProjectDescription description) {
        IFile file = project.getFile((IPath)new Path(".springBeans"));
        if (DEBUG) {
            System.out.println("Writing project description to " + file.getLocation().toString());
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                XMLWriter writer = new XMLWriter((OutputStream)os);
                BeansProjectDescriptionWriter.write(description, writer);
                writer.flush();
                writer.close();
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                os.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
            }
            os.close();
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream(os.toByteArray()), 1, null);
                return;
            }
            file.setContents((InputStream)new ByteArrayInputStream(os.toByteArray()), 1, null);
            return;
        }
        catch (IOException e) {
            BeansCorePlugin.log("Error writing " + file.getFullPath(), e);
            return;
        }
        catch (CoreException e) {
            BeansCorePlugin.log(e.getStatus());
        }
    }

    protected static void write(BeansProjectDescription description, XMLWriter writer) throws IOException {
        writer.startTag("beansProjectDescription", null);
        BeansProjectDescriptionWriter.write("configs", "config", description.getConfigNames(), writer);
        BeansProjectDescriptionWriter.write("configSets", description.getConfigSets(), writer);
        writer.endTag("beansProjectDescription");
    }

    protected static void write(IBeansConfigSet configSet, XMLWriter writer) throws IOException {
        writer.startTag("configSet", null);
        writer.printSimpleTag("name", (Object)configSet.getElementName());
        writer.printSimpleTag("allowBeanDefinitionOverriding", (Object)new Boolean(configSet.isAllowBeanDefinitionOverriding()).toString());
        writer.printSimpleTag("incomplete", (Object)new Boolean(configSet.isIncomplete()).toString());
        BeansProjectDescriptionWriter.write("configs", "config", configSet.getConfigs(), writer);
        writer.endTag("configSet");
    }

    protected static void write(String name, Collection collection, XMLWriter writer) throws IOException {
        writer.startTag(name, null);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            BeansProjectDescriptionWriter.write(iter.next(), writer);
        }
        writer.endTag(name);
    }

    protected static void write(Object obj, XMLWriter writer) throws IOException {
        if (obj instanceof IBeansConfigSet) {
            BeansProjectDescriptionWriter.write((BeansConfigSet)obj, writer);
        }
    }

    protected static void write(String name, String elementTagName, String[] array, XMLWriter writer) throws IOException {
        writer.startTag(name, null);
        int i = 0;
        while (i < array.length) {
            writer.printSimpleTag(elementTagName, (Object)array[i]);
            ++i;
        }
        writer.endTag(name);
    }

    protected static void write(String name, String elementTagName, Collection collection, XMLWriter writer) throws IOException {
        writer.startTag(name, null);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            writer.printSimpleTag(elementTagName, iter.next());
        }
        writer.endTag(name);
    }
}

