/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class SpringCore
extends Plugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.core";
    public static final String BUILDER_ID = "org.springframework.ide.eclipse.core.springbuilder";
    public static final String NATURE_ID = "org.springframework.ide.eclipse.core.springnature";
    public static final String MARKER_ID = "org.springframework.ide.eclipse.core.problemmarker";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.core.messages";
    private static SpringCore plugin;
    private ResourceBundle resourceBundle;

    public SpringCore() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static SpringCore getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = SpringCore.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                SpringCore.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        SpringCore.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = SpringCore.createErrorStatus(message, exception);
        SpringCore.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        SpringCore.getDefault().getLog().log(SpringCore.createErrorStatus(SpringCore.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static String getFormattedMessage(String key, String arg) {
        return SpringCore.getFormattedMessage(key, new String[]{arg});
    }

    public static String getFormattedMessage(String key, String[] args) {
        return MessageFormat.format(SpringCore.getResourceString(key), args);
    }
}

