/* ==================================================
 * JCommon : a general purpose class library for Java
 * ==================================================
 *
 * Project Info:  http://www.object-refinery.com/jcommon/index.html
 * Project Lead:  David Gilbert (david.gilbert@object-refinery.com);
 *
 * (C) Copyright 2000-2002, by Simba Management Limited and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * --------------
 * XYDataset.java
 * --------------
 * (C) Copyright 2000, 2001, by Simba Management Limited.
 *
 * Original Author:  David Gilbert (for Simba Management Limited);
 * Contributor(s):   -;
 *
 * $Id: XYDataset.java,v 1.3 2002/04/02 16:58:29 mungady Exp $
 *
 * Changes (from 18-Sep-2001)
 * --------------------------
 * 18-Sep-2001 : Added standard header and fixed DOS encoding problem (DG);
 * 15-Oct-2001 : Moved to a new package (com.jrefinery.data.*) (DG);
 * 22-Oct-2001 : Renamed DataSource.java --> Dataset.java etc. (DG);
 * 17-Nov-2001 : Now extends SeriesDataset (DG);
 *
 */

package com.jrefinery.data;

/**
 * An interface through which data in the form of (x, y) pairs can be accessed.
 * <P>
 * JFreeChart (http://www.jrefinery.com/jfreechart) uses this interface to obtain (x, y) data for
 * plotting charts.
 */
public interface XYDataset extends SeriesDataset {

    /**
     * Returns the number of items in a series.
     * @param series The series (zero-based index).
     * @return The number of items within a series.
     */
    public int getItemCount(int series);

    /**
     * Returns the x-value for an item within a series.
     * <P>
     * The implementation is responsible for ensuring that the x-values are presented in ascending
     * order.
     * @param series The series (zero-based index).
     * @param item The item (zero-based index).
     * @return The x-value for an item within a series.
     */
    public Number getXValue(int series, int item);

    /**
     * Returns the y-value for an item within a series.
     * @param series The series (zero-based index).
     * @param item The item (zero-based index).
     * @return The y-value for an item within a series.
     */
    public Number getYValue(int series, int item);

}
