#include <stdio.h>

#include <xview/xview.h>
#include <xview/defaults.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>

#include "generic.h"

typedef struct {
	ltgenericd g;
	Frame f;		/* xview frame */
	tpanel p;	/* command frame panel (for dialogs) */
	tdisplay dpy;	/* display */
	int footer;	/* 1 if footer is on */
	int (*do_events)();
	int (*do_destroy)();
	int dialog;
	} ltframed, *ltframe;

Notify_value frame_event_handler(xf, e, a, t)
Frame xf;
Event *e;
Notify_arg a;
Notify_event_type t;
{
	Notify_value val;
	ltframe f;
	int x=0, y=0, w=0, h=0;
	tevent te;

	f=(ltframe)xv_get(xf, WIN_CLIENT_DATA);

	if(event_action(e)==WIN_RESIZE)
	{
		w=xv_get(xf, XV_WIDTH);
		h=xv_get(xf, XV_HEIGHT);
	}
	x=event_x(e);
	y=event_y(e);

	te=(tevent)tevent_create_from_xviewevent(e, x, y, w, h);
	if(f->do_events != NULL)
	{
		if((*f->do_events)(f, te))
			val=NOTIFY_IGNORED;
		else
			val=notify_next_event_func(xf,e,a,t);
	}
	else
		val=notify_next_event_func(xf,e,a,t);
	tevent_free(te);
	return(val);
}

Notify_value tframe_destroy(xf, status)
Notify_client xf;
Destroy_status status;
{
	ltframe f;

	f=(ltframe)xv_get(xf, WIN_CLIENT_DATA);
	
	switch(status)
	{
		case DESTROY_CHECKING:
			if(f->do_destroy!=NULL)
				if(!(f->do_destroy)(f))
					notify_veto_destroy(xf);
			return(NOTIFY_DONE);
			break;
		case DESTROY_PROCESS_DEATH:
		case DESTROY_CLEANUP:
		case DESTROY_SAVE_YOURSELF:
		default:
			return notify_next_destroy_func(xf, status);
			break;
	}
}

int tframe_loop(f)
ltframe f;
{
    /* check type */
    if(f==NULL)
        return(0);
    if(titem_type(f)!=lt_frame)
        return(0);

    xv_main_loop(f->f);
	return(1);
}

tframe tframe_new(parent,x,y,w,h,resize,dialog,footer,label,args)
titem parent;
int x,y,w,h;
int resize,dialog,footer;
char *label;
targs args;
{
	ltframe f;
	Frame p;
	Rect r;
	XColor bg;
	char *colorstring;

	/* get parent type */
	if(parent==NULL)
		p=NULL;
	else if(titem_type(parent)==lt_frame)
	{
		p=((ltframe)parent)->f;
	}
	else
		return(NULL);
	
	/* get memory */
	f=(ltframe)titem_new(parent, lt_frame, sizeof(ltframed));
	if(f==NULL)
		return(NULL);

	f->dialog=dialog;
	/* create, normal or subrame */
	if(!dialog)
	{
		f->f=(Frame)xv_create(p, FRAME,
			FRAME_LABEL, label,
			WIN_CLIENT_DATA, f,
			NULL);
		f->p=NULL;
	}
	else
	{
		f->f=(Frame)xv_create(p, FRAME_CMD,
			FRAME_LABEL, label,
			WIN_CLIENT_DATA, f,
			FRAME_CMD_PUSHPIN_IN, TRUE,
			NULL);
		/*xv_set(f->f, WIN_CONSUME_X_EVENT_MASK, NULL);*/
		f->p=(tpanel)tpanel_new_from_dialog(f);
	}

	/* setup display pointer */
	if(parent==NULL)
		f->dpy=(tdisplay)tdisplay_create_from_xdpy(xv_get(f->f, XV_DISPLAY));
	else
		f->dpy=((ltframe)parent)->dpy;

	/* setup size */
	if(w!=0 && h!=0)
	{
		r.r_top=y;
		r.r_left=x;
		r.r_width=w;
		r.r_height=h;
		frame_set_rect(f->f, &r);
	}

	/* setup footer */
	if(footer)
	{
		f->footer=1;
		xv_set(f->f, FRAME_SHOW_FOOTER, TRUE, NULL);
	}
	else
		f->footer=0;
	
	/* setup color */
	colorstring=defaults_get_string("openwindows.windowcolor",
		"OpenWindows.WindowColor", "#000000");
	XParseColor(tdisplay_X(f->dpy), tdisplay_XColormap(f->dpy),
		colorstring, &bg);
	XAllocColor(tdisplay_X(f->dpy), tdisplay_XColormap(f->dpy),
		&bg);
	XSetWindowBackground(tdisplay_X(f->dpy),
		xv_get(f->f, XV_XID), bg.pixel);

	/* show */
	xv_set(f->f, XV_SHOW, FALSE, NULL);

	/* setup local event procedure */
	notify_interpose_event_func(f->f, frame_event_handler, NOTIFY_SAFE);
	/* set up no initial event procedure */
	f->do_events=NULL;
	f->do_destroy=NULL;
	return((tframe)f);
}

int tframe_set_width(f, h)
ltframe f;
int h;
{
	xv_set(f->f, XV_WIDTH, h, NULL);
}

int tframe_set_height(f, h)
ltframe f;
int h;
{
	xv_set(f->f, XV_HEIGHT, h, NULL);
}

tpanel tframe_dialog_panel(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);
	return(f->p);
}

int tframe_free(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	if(xv_destroy_safe(f->f)!=XV_OK)
		return(0);
	return(titem_free(f));
}

int tframe_set_footer(f, string)
ltframe f;
char *string;
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	/* set the footer, if the frame has one */
	if(f->footer)
		xv_set(f->f, FRAME_LEFT_FOOTER, string, NULL);
	return(1);
}

int tframe_show(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	/* show the frame */
	xv_set(f->f, XV_SHOW, TRUE, NULL);
	return(1);
}

int tframe_hide(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	/* hide the frame */
	xv_set(f->f, XV_SHOW, FALSE, NULL);
	return(1);
}

int tframe_move(f, win, x, y)
ltframe f;
void *win;
int x, y;
{
	int nx, ny;
	Window nw;
	Window parent;
	Bool result;
	Xv_window w;

	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	parent=tdisplay_XRoot(f->dpy);
	w=(Xv_window)titem_xview_window(win);

	if(w!=NULL)
		result=XTranslateCoordinates(tdisplay_X(f->dpy), xv_get(w, XV_XID),
			parent, x, y, &nx, &ny, &nw);
	else
	{
		nx=x;
		ny=y;
	}

	xv_set(f->f, XV_X, nx, XV_Y, ny, NULL);
	return(1);
}

int tframe_fit(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	/* fit the frame */
	window_fit(f->f);
	return(1);
}

int tframe_set_event_procedure(f, do_events)
ltframe f;
int (*do_events)();
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	/* setup the event procedure */
	f->do_events=do_events;
	return(1);
}

int tframe_set_destroy_procedure(f, do_destroy)
ltframe f;
int (*do_destroy)();
{
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	/* setup the event procedure */
	notify_interpose_destroy_func(f->f, tframe_destroy);
	f->do_destroy=do_destroy;
	return(1);
}

tdisplay tframe_display(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(NULL);
	if(titem_type(f)!=lt_frame)
		return(NULL);

	/* return the X display */
	return(f->dpy);
}

Frame tframe_xview(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(NULL);
	if(titem_type(f)!=lt_frame)
		return(NULL);

	/* return the xview Frame */
	return(f->f);
}

Drawable tframe_drawable(f)
ltframe f;
{
	/* check if it's a frame */
	if(f==NULL)
		return(NULL);
	if(titem_type(f)!=lt_frame)
		return(NULL);

	/* return the x window */
	return(xv_get(f->f, XV_XID));
}

int tframe_set_min_size(f, minw, minh)
ltframe f;
int minw, minh;
{
	XSizeHints hnt;
	/* check if it's a frame */
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);

	hnt.min_width=minw;
	hnt.min_height=minh;
	hnt.flags=PMinSize;
	XSetSizeHints(tdisplay_X(f->dpy), xv_get(f->f, XV_XID), &hnt,
		XA_WM_NORMAL_HINTS);
	return(1);
}

int tframe_push_pin(f)
ltframe f;
{
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);
	if(!f->dialog)
		return(0);

	xv_set(f->f, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
}

int tframe_pull_pin(f)
ltframe f;
{
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);
	if(!f->dialog)
		return(0);

	xv_set(f->f, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
}

void *tframe_notice_window(f)
ltframe f;
{
	if(f==NULL)
		return(0);
	if(titem_type(f)!=lt_frame)
		return(0);
	
	return((void *)(f->f));
}

void tframe_set_busy(f)
ltframe f;
{
	if(f==NULL)
		return;
	if(titem_type(f)!=lt_frame)
		return;
	
	xv_set(f->f, FRAME_BUSY, TRUE, NULL);
}

void tframe_set_notbusy(f)
ltframe f;
{
	if(f==NULL)
		return;
	if(titem_type(f)!=lt_frame)
		return;
	
	xv_set(f->f, FRAME_BUSY, FALSE, NULL);
}

void tframe_set_name(f, s)
ltframe f;
char *s;
{
	if(f==NULL || s==NULL)
		return;
	if(titem_type(f)!=lt_frame || *s=='\0')
		return;
	
	xv_set(f->f, FRAME_LABEL, s, NULL);
}

int tframe_set_icon(f, i, label)
ltframe f;
tpic i;
char *label;
{
	Icon xi;
	int roomforlbl;

	if(f==NULL || i==NULL)
		return(0);
	if(titem_type(f)!=lt_frame || titem_type(i)!=lt_pic)
		return(0);
	
	xi=tpic_icon(i, label);
	if(xi==NULL)
		return(0);
	
	xv_set(f->f, FRAME_ICON, xi, NULL);
	return(1);
}

int tframe_height(f)
ltframe f;
{
	return(xv_get(f->f, XV_HEIGHT));
}

int tframe_width(f)
ltframe f;
{
	return(xv_get(f->f, XV_WIDTH));
}

int tframe_x(f)
ltframe f;
{
	return(xv_get(f->f, XV_X));
}

int tframe_y(f)
ltframe f;
{
	return(xv_get(f->f, XV_Y));
}
