/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeDeadNoteAction extends Action{
    public static final String NAME = "action.note.effect.change-dead";
    
    public ChangeDeadNoteAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        //comienza el undoable
        UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();
    	
        Note note = null;
    	Caret caret = getEditor().getTablature().getCaret();
        MeasureComponent component = caret.getMeasureCoords().getComponent(caret.getPosition(),caret.getSelectedString().getNumber());
        if(component instanceof NoteCoords){
        	note = ((NoteCoords)component).getNote();
        }
        if(note == null){
            Duration duration = (Duration)caret.getDuration().clone();
            InstrumentString string = new InstrumentString(caret.getSelectedString().getNumber(), caret.getSelectedString().getValue()); 
            note = new Note(0,caret.getPosition(),duration,caret.getVelocity(), string.getNumber(),false,new NoteEffect());
            getSongManager().getMeasureManager().addNote(caret.getMeasureCoords().getMeasure(),note);
        }
        getSongManager().getMeasureManager().changeDeadNote(note);
        
        updateTablature();	    
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo());             
        
        return true;
    }
    

    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }        

}
