/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.SilenceCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class RemoveNoteAction extends Action{
    public static final String NAME = "action.note.general.remove";
    
    public RemoveNoteAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        //comienza el undoable
        UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();     
    	
        Caret caret = getEditor().getTablature().getCaret();
        if(caret.getSelectedComponent() instanceof SilenceCoords){              	        	
            SilenceCoords silenceCoords = (SilenceCoords)caret.getSelectedComponent();                               
            getSongManager().getMeasureManager().removeSilence(caret.getMeasureCoords().getMeasure(),silenceCoords.getSilence(),true);
        }else{
            long start = caret.getSelectedComponent().getStart();
            int string = caret.getSelectedString().getNumber();        
            getSongManager().getMeasureManager().removeComponentsAt(caret.getMeasureCoords().getMeasure(),start, string,true);       
        }                        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo());                    
        updateTablature();          
        
        return true;
    }
    
    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }    

}
