/*
 * Created on 30-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.VelocityValues;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class Caret {
    private Tablature tablature;
    private SongManager songManager;
    private SongCoords songCoords;
    private SongTrackCoords selectedTrack;
    private MeasureCoords selectedMeasure;
    private MeasureComponent selectedComponent;
    private Duration selectedDuration;
    private long position;
    private int string;
    private boolean changes;    
    private int velocity;
    
    private Note selectedNote;
    
    public Caret(Tablature tablature,SongManager songManager, SongCoords songCoords) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.songCoords = songCoords;
        this.selectedDuration = new Duration(Duration.QUARTER);
        this.string = 1;
        this.velocity = VelocityValues.DEFAULT;
        this.changes = false;
    }

    public synchronized void update(){
    	int trackNumber = (selectedTrack != null)?selectedTrack.getTrack().getNumber():1;    	
    	update(trackNumber,position,string);
    }    
    
    public synchronized void update(int trackNumber){    	
    	update(trackNumber,position,string);
    }      
    
    public synchronized void update(int trackNumber,long position,int string){
    	update(trackNumber, position, string,getVelocity());
    }
    
    public synchronized void update(int trackNumber,long position,int string,int velocity) {         
    	position = ((TuxGuitar.instance().getPlayer().isRunning())?TuxGuitar.instance().getPlayer().getTickPosition():position);    	
    	SongTrackCoords track = findTrack(trackNumber); 
        MeasureCoords measure = findMeasure(position,track);
        MeasureComponent component = findComponent(position,string,measure);
        if(track != null && measure != null && component != null){
        	moveTo(track, measure, component,string);
        }        
        setVelocity(velocity);
    }
        	
    public void moveTo(SongTrackCoords selectedTrack, MeasureCoords selectedMeasure, MeasureComponent selectedComponent,int string) {        
    	this.selectedTrack = selectedTrack;
    	this.selectedMeasure = selectedMeasure;
    	this.selectedComponent = selectedComponent;
        this.string = string;        
        this.updatePosition();
        this.updateDuration();   
        this.checkString();
        this.updateNote();
        this.checkTransport();
        this.setChanges(true);
    }    
    
    private SongTrackCoords findTrack(int trackNumber){
    	SongTrackCoords trackCoords = songCoords.getTrack(trackNumber);
        if(trackCoords == null){
        	trackCoords = songCoords.getFirstTrack();
        }
        return trackCoords;
    }
    
    private MeasureCoords findMeasure(long position,SongTrackCoords trackCoords){
    	MeasureCoords measureCoords = null;
    	if(trackCoords != null){
    		measureCoords = trackCoords.getMeasureCoords(position);
    		if(measureCoords == null){
    			measureCoords = trackCoords.getFirstMeasure();
    		}
    	}
    	return measureCoords;
    }
    
    private MeasureComponent findComponent(long position,int string,MeasureCoords measure){
    	MeasureComponent component = null;
    	if(measure != null){
    		component = measure.getComponentOrSilence(position,string);
    		if (component == null) {
    			component = measure.getFirstComponent();
    		}    		
    	}
    	return component;
    }
    
    public synchronized void goToTickPosition(){    
    	if(!songManager.isAtPosition(selectedMeasure.getMeasure().getHeader(),TuxGuitar.instance().getPlayer().getTickPosition())){
    		this.update(selectedTrack.getTrack().getNumber(),TuxGuitar.instance().getPlayer().getTickPosition(),string);
    		this.setChanges(true);
    	}
    }    
    
    public void paintCaret(ViewLayout layout,GC gc) {
        if (selectedMeasure != null && selectedComponent != null) {
            long start = this.selectedComponent.getStart();
            int startPosition = TablatureUtil.getStartPosition(selectedMeasure.getMeasure(), start, selectedMeasure.getQuarterSpan()) + this.selectedComponent.getSpan();
            int xSpan = MeasureHeaderGui.DEFAULT_LEFT_SPAN + selectedMeasure.getFirstNoteSpan(); 
            
            if(layout.isTablatureEnabled()){
            	int stringSpan = this.tablature.getViewLayout().getStringSpan();
            	int x = selectedMeasure.getPosX() + xSpan + startPosition + 6;
            	int y = selectedMeasure.getPosY() + selectedMeasure.getTs().getPosition(TrackSpacing.POSITION_TABLATURE) + ((string * stringSpan) - stringSpan) - 7;            	
            	int width = 14;
            	int height = 14;
            	gc.drawRectangle(x, y, width, height);     
            }
            if(layout.isScoreEnabled()){
            	//TODO: dibujar caret para partitura
            }
                   
        }
        
    }

    public boolean moveRight() {        
        if (getSelectedComponent() != null) {        	
        	MeasureCoords nextMeasure = getMeasureCoords();
        	MeasureComponent nextComponent = getMeasureCoords().getNextComponent(getSelectedComponent());        	
            if (nextComponent == null){
                //si no habia mas componentes. busco el siguiente compas
            	nextMeasure = getSongTrackCoords().getNextMeasure(getMeasureCoords());
                if (nextMeasure == null) {
                    return false;
                }      
                nextComponent = nextMeasure.getFirstComponent();                
            }
            moveTo(getSongTrackCoords(), nextMeasure, nextComponent, getStringNumber());           	        	
        }
        return true;
    }

    public void moveLeft() {
        if (getSelectedComponent() != null) {
        	MeasureCoords prevMeasure = getMeasureCoords();
            MeasureComponent prevComponent = getMeasureCoords().getPreviousComponent(getSelectedComponent());
            if (prevComponent == null) {
                //si no habia mas componentes. busco el compas anterior
            	prevMeasure = getSongTrackCoords().getPrevMeasure(getMeasureCoords());
                if (prevMeasure == null) {
                	return;
                }                      
                prevComponent = prevMeasure.getLastComponent();                
            }      
            moveTo(getSongTrackCoords(), prevMeasure, prevComponent, getStringNumber());    
        }
    }

    /**
     * Luego de mover el Caret. cambia la duracion seleccionada por la del componente. solo si lo que resta del compas no esta vacio
     */
    private void updateDuration() {
        if (this.selectedComponent != null) {
            boolean hasNotes = false;
            Iterator it = getMeasureCoords().getComponentsBeforeEnd(getSelectedComponent().getStart()).iterator();
            while (it.hasNext()) {
                MeasureComponent component = (MeasureComponent) it.next();
                if (component instanceof NoteCoords) {
                    hasNotes = true;
                    break;
                }
            }
            if (hasNotes) {
                if(this.selectedComponent instanceof SilenceCoords){
                    long length = this.selectedComponent.getDuration().getTime();
                    
                    MeasureComponent nextComponent = getMeasureCoords().getNextComponent(this.selectedComponent);
                    while(nextComponent != null && nextComponent instanceof SilenceCoords){
                        length += nextComponent.getDuration().getTime();                        
                        nextComponent = getMeasureCoords().getNextComponent(nextComponent);
                    }
                    
                    if(this.selectedDuration.getTime() > length){
                        this.selectedDuration = (Duration) this.selectedComponent.getDuration().clone();   
                    }
                }else{
                    this.selectedDuration = (Duration) this.selectedComponent.getDuration().clone();
                }                                
            }
        }
    }

    public void moveUp() {
    	int stringCount = this.selectedTrack.getTrack().stringCount() ;
    	int nextString = (( (this.string - 2 + stringCount) % stringCount) + 1);    	
    	setStringNumber(nextString);
    }

    public void moveDown() {
    	int stringCount = this.selectedTrack.getTrack().stringCount() ;
    	int nextString = ( (this.string  % stringCount) + 1);      	
    	setStringNumber(nextString);
    }

    public void setStringNumber(int number){
    	this.string = number;
    	this.updateNote();
    }
    
    public int getStringNumber(){
    	return this.string;
    }
    
    public long getPosition() {
        return this.position;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public MeasureCoords getMeasureCoords() {
        return this.selectedMeasure;
    }

    public SongTrackCoords getSongTrackCoords() {
        return this.selectedTrack;
    }

    public MeasureComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public Duration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(Duration selectedDuration) {
        this.selectedDuration = selectedDuration;
    }

    public InstrumentString getSelectedString() {
        List strings = this.selectedTrack.getTrack().getStrings();
        Iterator it = strings.iterator();
        while (it.hasNext()) {
            InstrumentString instrumentString = (InstrumentString) it.next();
            if (instrumentString.getNumber() == this.string) {
                return instrumentString;
            }
        }
        return null;
    }
    
    public void changeDuration(Duration duration){
    	getSongCoords().getSongManager().getMeasureManager().changeDuration(getMeasureCoords().getMeasure(),getSelectedComponent().getComponent(),duration);
        setChanges(true);
    }
    
    private void updatePosition(){
        this.position = getSelectedComponent().getStart();
    }
    
    private void checkString(){
        int stringCount = getSongTrackCoords().getTrack().getStrings().size();
        if(this.string > stringCount){
            this.string = stringCount;
        }
    }    
    
    private void checkTransport(){
    	TuxGuitar.instance().getTransport().gotoMeasure(getMeasureCoords().getMeasure().getHeader());
    }
    
    public boolean hasChanges() {
        return changes;
    }
    public void setChanges(boolean changes) {
        this.changes = changes;
    }

    
    
	public int getVelocity() {
		return velocity;
	}
	
	public void setVelocity(int velocity) {
		this.velocity = velocity;
	}

	private void updateNote(){
		this.selectedNote = this.songManager.getMeasureManager().getNote(getMeasureCoords().getMeasure(),getPosition(),getSelectedString().getNumber());
	}
	
	public Note getSelectedNote(){
		return this.selectedNote;
	}
}