/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab.layout;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class LinearViewLayout extends ViewLayout{

    public LinearViewLayout(Tablature tablature,SongManager songManager,boolean multitrack,boolean scoreEnabled,boolean tablatureEnabled){
        super(tablature,songManager,multitrack,scoreEnabled,tablatureEnabled);
    }
    
    public int getMode(){
    	return MODE_LINEAR;
    }
    
    public void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY){  
    	clearTrackPositions();
        if(isMultitrack()){
            paintTracks(getTablature().getCaret().getSongCoords().getTrackCoords(),gc,clientArea,fromX,fromY);
        }else{
            List tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
            paintTracks(tracksCoords,gc,clientArea,fromX,fromY);
        }        
        paintCaret(gc);
    }
    
    public void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY) {               
    	int posY = fromY + getDefaultFirstTrackSpan();        
        int height = getDefaultFirstTrackSpan();   
        int trackHeight;
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords) tracksCoords.get(trackIdx);            
            TrackSpacing ts = new TrackSpacing(this) ;
            ts.setSize(TrackSpacing.POSITION_SCORE_MIDDLE_LINES, ((isScoreEnabled())?( (DEFAULT_SCORE_LINE_SPAN * 5) ):0));            
            trackCoords.getLyricPainter().start();
            
            //------AUTO_SPACING---------------------------------------
            if(AUTO_SPACING_ENABLED){
            	int maxY = 0;
            	int minY = 0;
            	for(int i = 0;i < trackCoords.getMeasuresCoords().size();i++){
            		MeasureCoords measure = (MeasureCoords)trackCoords.getMeasuresCoords().get(i);
            		maxY = (measure.getMaxY() > maxY)?measure.getMaxY():maxY;
            		minY = (measure.getMinY() < minY)?measure.getMinY():minY;
            		measure.registerEffects(ts);
            	}             	
            	ts.setSize(TrackSpacing.POSITION_SCORE_UP_LINES, ((isScoreEnabled())?Math.abs(minY):0));            	            	
            	if(isScoreEnabled() && maxY + MIN_SCORE_TAB_SPAN > DEFAULT_SCORE_SPAN){
            		ts.setSize(TrackSpacing.POSITION_SCORE_DOWN_LINES, (maxY - (getScoreLineSpan() * 4)) );
            	}		
			}                        
            ts.setSize(TrackSpacing.POSITION_TABLATURE_TOP_SEPARATOR,(isScoreEnabled()?getMinScoreTabSpan():getStringSpan()));
            ts.setSize(TrackSpacing.POSITION_TABLATURE, ( isTablatureEnabled()?(isScoreEnabled()?trackCoords.getTabHeight() + getStringSpan() +1:trackCoords.getTabHeight() + ((getStringSpan() / 2) * 5) +1 ) :0) );
            ts.setSize(TrackSpacing.POSITION_LYRIC,10);                        
        	checkTopSpan(ts);
            
            //----------------------------------------------------                                
            paintMeasures(trackCoords,trackCoords.getMeasuresCoords(),gc,fromX,posY,ts,clientArea);            
            paintLines(trackCoords,ts,gc,fromX + (getWidth() + 2),posY,(clientArea.width - (fromX + getWidth()) ));
           
            trackHeight = ts.getSize();
            addTrackPosition((int)trackCoords.getTrack().getNumber(),posY,trackHeight);            
            
            posY += trackHeight + DEFAULT_TRACK_SPAN;
			height += trackHeight + DEFAULT_TRACK_SPAN;    
        }                  
        setHeight(height);        
    }
  
    public void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,TrackSpacing ts,Rectangle clientArea) {        
    	int posX = (fromX + DEFAULT_HORIZONTAL_SPAN);
        int posY = fromY;
        
        for (int measureIdx = 0; measureIdx < measuresCoords.size(); measureIdx++) {            
            MeasureCoords measureCoords = (MeasureCoords) measuresCoords.get(measureIdx);            
                      
            //asigno la posicion dentro del compas
            measureCoords.setPosX(posX);
            measureCoords.setPosY(posY);            
            measureCoords.setTs(ts);
            
            trackCoords.getLyricPainter().setCurrentMeasure(measureCoords);
            
            //Solo pinto lo que entre en pantalla  
            boolean isAtX = ((posX + measureCoords.getWidth()) > clientArea.x - 100 && posX < clientArea.x + clientArea.width + measureCoords.getWidth() + 100);
            boolean isAtY = (posY + ts.getSize() > clientArea.y && posY < clientArea.y + clientArea.height + 80);
            if(isAtX && isAtY){
                paintMeasure(measureCoords,gc,posX, posY,0,clientArea);
                trackCoords.getLyricPainter().paintCurrentNoteBeats(gc,this,measureCoords,posX, posY);
            }else{
            	measureCoords.setOutOfBounds(true);
            } 
            posX += measureCoords.getWidth();       
        }
        setWidth(posX + (-fromX));
    }
    
    public boolean followMeasure(MeasureCoords measure,boolean redraw){
        return getTablature().moveScrollHorizontalTo(measure,DEFAULT_HORIZONTAL_SPAN,redraw);
    }   
}
