package org.herac.tuxguitar.gui.editors.tab.layout;

public class TrackSpacing {		
	public static final int SCORE = 0x01; 
	public static final int TABLATURE = 0x02;
	
	public static final int POSITION_TOP = 0;
	public static final int POSITION_SCORE_UP_LINES = 1;
	public static final int POSITION_SCORE_MIDDLE_LINES = 2;
	public static final int POSITION_SCORE_DOWN_LINES = 3;	
	public static final int POSITION_TUPLETO = 4;
	public static final int POSITION_ACCENTUATED_EFFECT = 5;
	public static final int POSITION_HARMONIC_EFFEC = 6;
	public static final int POSITION_TAPPING_EFFEC = 7;
	public static final int POSITION_PALM_MUTE_EFFEC = 8;
	public static final int POSITION_VIBRATO_EFFEC = 9;	
	public static final int POSITION_FADE_IN = 10;
	public static final int POSITION_TABLATURE_TOP_SEPARATOR = 11;
	public static final int POSITION_TABLATURE = 12;
	public static final int POSITION_LYRIC = 13;
	public static final int POSITION_BOTTOM = 14;
	
	private static final int[][] POSITIONS = new int[][]{
		/** SCORE **/
		new int[]{
				0, //POSITION_TOP
				1, //POSITION_SCORE_UP_LINES
				2, //POSITION_SCORE_MIDDLE_LINES
				3, //POSITION_SCORE_DOWN_LINES	
				4, //POSITION_TUPLETO
				5, //POSITION_ACCENTUATED_EFFECT
				6, //POSITION_HARMONIC_EFFEC
				7, //POSITION_TAPPING_EFFEC
				8, //POSITION_PALM_MUTE_EFFEC
				9, //POSITION_VIBRATO_EFFEC
				10, //POSITION_FADE_IN
				11, //POSITION_TABLATURE_TOP_SEPARATOR
				12, //POSITION_TABLATURE
				13, //POSITION_LYRIC
				14, //POSITION_BOTTOM					
			},

		/** TABLATURE **/
		new int[]{
				0, //POSITION_TOP
				12, //POSITION_SCORE_UP_LINES
				13, //POSITION_SCORE_MIDDLE_LINES
				14, //POSITION_SCORE_DOWN_LINES	
				9, //POSITION_TUPLETO
				6, //POSITION_FADE_IN				
				2, //POSITION_HARMONIC_EFFEC
				3, //POSITION_TAPPING_EFFEC
				4, //POSITION_PALM_MUTE_EFFEC
				5, //POSITION_VIBRATO_EFFEC
				1, //POSITION_ACCENTUATED_EFFECT
				7, //POSITION_TABLATURE_TOP_SEPARATOR
				8, //POSITION_TABLATURE
				10, //POSITION_LYRIC
				11, //POSITION_BOTTOM					
			},	
			
		/** SCORE & TABLATURE **/
		new int[]{
				0, //POSITION_TOP
				1, //POSITION_SCORE_UP_LINES
				2, //POSITION_SCORE_MIDDLE_LINES
				3, //POSITION_SCORE_DOWN_LINES	
				4, //POSITION_TUPLETO
				5, //POSITION_ACCENTUATED_EFFECT
				6, //POSITION_HARMONIC_EFFEC
				7, //POSITION_TAPPING_EFFEC
				8, //POSITION_PALM_MUTE_EFFEC
				9, //POSITION_VIBRATO_EFFEC
				10, //POSITION_FADE_IN
				11, //POSITION_TABLATURE_TOP_SEPARATOR
				12, //POSITION_TABLATURE
				13, //POSITION_LYRIC
				14, //POSITION_BOTTOM						
			},
	};

	private int flags;
	private int[] spacing;
	
	public TrackSpacing(ViewLayout layout){
		this.flags = 0;
		this.flags |= (layout.isScoreEnabled()?SCORE:0);
		this.flags |= (layout.isTablatureEnabled()?TABLATURE:0);
		this.spacing = new int[15];
	}		
	
	public void setSize(int index,int size){
		this.spacing[ POSITIONS [this.flags -1] [index] ] = size;
	}
	
	public int getSize(){
		int span = 0;		
		for(int i = 0;i < this.spacing.length; i ++){
			span += this.spacing[i];
		}  			 				
		return span;
	}
	
	public int getPosition(int index){				
		int span = 0;
		for(int i = 0;i < POSITIONS[this.flags -1][index]; i ++){
			span += this.spacing[i];
		}
		return span;
	}  

}
