/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.composition.ChangeClefAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeInfoAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeKeySignatureAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTempoAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTimeSignatureAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTripletFeelAction;
import org.herac.tuxguitar.gui.actions.insert.CloseRepeatAction;
import org.herac.tuxguitar.gui.actions.insert.OpenRepeatAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CompositionMenuItem implements MenuItems{
    private TablatureEditor tablatureEditor;
    private MenuItem compositionMenuItem;
    private Menu menu; 
    private MenuItem timeSignature;
    private MenuItem tempo;
    private MenuItem clef;
    private MenuItem keySignature;    
    private MenuItem openRepeat;
    private MenuItem closeRepeat;
    private MenuItem tripletFeel;
    
    private MenuItem properties;
    
    public CompositionMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.compositionMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }    
    
    public void showItems(){                        
        //--TIME SIGNATURE--
        this.timeSignature = new MenuItem(this.menu, SWT.PUSH); 
        this.timeSignature.setImage(SystemImages.TIME_SIGNATURE_IMAGE);
        this.timeSignature.addSelectionListener(TuxGuitar.instance().getAction(ChangeTimeSignatureAction.NAME));
        //--TEMPO--
        this.tempo = new MenuItem(this.menu, SWT.PUSH);
        this.tempo.setImage(SystemImages.TEMPO_ICON_IMAGE);
        this.tempo.addSelectionListener(TuxGuitar.instance().getAction(ChangeTempoAction.NAME));
        //--CLEF--
        this.clef = new MenuItem(this.menu, SWT.PUSH); 
        this.clef.addSelectionListener(TuxGuitar.instance().getAction(ChangeClefAction.NAME));
        //--KEY SIGNATURE--
        this.keySignature = new MenuItem(this.menu, SWT.PUSH); 
        this.keySignature.addSelectionListener(TuxGuitar.instance().getAction(ChangeKeySignatureAction.NAME));
        //--TRIPLET FEEL--
        this.tripletFeel = new MenuItem(this.menu, SWT.PUSH); 
        this.tripletFeel.addSelectionListener(TuxGuitar.instance().getAction(ChangeTripletFeelAction.NAME));        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--REPEAT OPEN--
        this.openRepeat = new MenuItem(this.menu, SWT.PUSH);
        this.openRepeat.setImage(SystemImages.OPEN_REPEAT_IMAGE);
        this.openRepeat.addSelectionListener(TuxGuitar.instance().getAction(OpenRepeatAction.NAME));            
        //--REPEAT CLOSE--        
        this.closeRepeat = new MenuItem(this.menu, SWT.PUSH);
        this.closeRepeat.setImage(SystemImages.CLOSE_REPEAT_IMAGE);
        this.closeRepeat.addSelectionListener(TuxGuitar.instance().getAction(CloseRepeatAction.NAME));                
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);        
        //--INFO--
        this.properties = new MenuItem(this.menu, SWT.PUSH);
        this.properties.setImage(SystemImages.SONG_PROPERTIES);
        this.properties.addSelectionListener(TuxGuitar.instance().getAction(ChangeInfoAction.NAME));
        
        this.compositionMenuItem.setMenu(menu);
        
        this.loadProperties();
    }    
    
    public void update(){
        
    }
    

    public void loadProperties(){
        this.compositionMenuItem.setText(TuxGuitar.getProperty("composition"));
        this.timeSignature.setText(TuxGuitar.getProperty("composition.timesignature"));
        this.tempo.setText(TuxGuitar.getProperty("composition.tempo"));
        this.clef.setText(TuxGuitar.getProperty("composition.clef"));
        this.keySignature.setText(TuxGuitar.getProperty("composition.keysignature"));
        this.tripletFeel.setText(TuxGuitar.getProperty("composition.tripletfeel"));
        this.openRepeat.setText(TuxGuitar.getProperty("repeat.open"));
        this.closeRepeat.setText(TuxGuitar.getProperty("repeat.close"));           
        this.properties.setText(TuxGuitar.getProperty("composition.properties"));
    }    
}
