/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.effects.ChangeAccentuatedNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeBendNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeDeadNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeFadeInAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeGhostNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeGraceNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHammerNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHarmonicNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHeavyAccentuatedNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangePalmMuteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangePoppingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeSlappingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeSlideNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeStaccatoAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTappingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTremoloBarAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTremoloPickingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTrillNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeVibratoNoteAction;
import org.herac.tuxguitar.gui.items.ToolItems;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NoteEffectToolItems  extends ToolItems{
    public static final String NAME = "effect.items";
    
    private ToolBar toolBar;
    
    private ToolItem deadNote;
    private ToolItem ghostNote;
    private ToolItem accentuatedNote;
    private ToolItem heavyAccentuatedNote;    
    private ToolItem harmonicNote;
    private ToolItem graceNote;
    
    private ToolItem vibrato;
    private ToolItem bend;    
    private ToolItem tremoloBar;
    private ToolItem slide;
    private ToolItem hammer;
    
    private ToolItem trill;
    private ToolItem tremoloPicking;
    private ToolItem palmMute;	
    
    private ToolItem staccato;    
    private ToolItem tapping;
    private ToolItem slapping;
    private ToolItem popping;
    
    private ToolItem fadeIn;
    
    public NoteEffectToolItems(){
    	super(NAME);
    }
   
    public void showItems(ToolBar toolBar){
    	this.toolBar = toolBar;         
        //--DEAD NOTE--
        this.deadNote = new ToolItem(toolBar, SWT.CHECK);
        this.deadNote.setImage(SystemImages.EFFECT_DEAD);
        this.deadNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeDeadNoteAction.NAME));

        //--GHOST NOTE--
        this.ghostNote = new ToolItem(toolBar, SWT.CHECK);
        this.ghostNote.setImage(SystemImages.EFFECT_GHOST);
        this.ghostNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeGhostNoteAction.NAME));        
        
        //--ACCENTUATED NOTE--
        this.accentuatedNote = new ToolItem(toolBar, SWT.CHECK);
        this.accentuatedNote.setImage(SystemImages.EFFECT_ACCENTUATED);
        this.accentuatedNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeAccentuatedNoteAction.NAME));   
        
        //--HEAVY ACCENTUATED NOTE--
        this.heavyAccentuatedNote = new ToolItem(toolBar, SWT.CHECK);
        this.heavyAccentuatedNote.setImage(SystemImages.EFFECT_HEAVY_ACCENTUATED);
        this.heavyAccentuatedNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeHeavyAccentuatedNoteAction.NAME));           
        
        //--HARMONIC NOTE--
        this.harmonicNote = new ToolItem(toolBar, SWT.CHECK);
        this.harmonicNote.setImage(SystemImages.EFFECT_HARMONIC);
        this.harmonicNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeHarmonicNoteAction.NAME));  
        
        //--GRACE NOTE--
        this.graceNote = new ToolItem(toolBar, SWT.CHECK);
        this.graceNote.setImage(SystemImages.EFFECT_GRACE);
        this.graceNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeGraceNoteAction.NAME));          
        
        //--SEPARATOR--
        new ToolItem(toolBar, SWT.SEPARATOR);        
        
        //--VIBRATO--
        this.vibrato = new ToolItem(toolBar, SWT.CHECK);
        this.vibrato.setImage(SystemImages.EFFECT_VIBRATO);
        this.vibrato.addSelectionListener(TuxGuitar.instance().getAction(ChangeVibratoNoteAction.NAME));        

        //--BEND--
        this.bend = new ToolItem(toolBar, SWT.CHECK);
        this.bend.setImage(SystemImages.EFFECT_BEND);
        this.bend.addSelectionListener(TuxGuitar.instance().getAction(ChangeBendNoteAction.NAME));        
        
        //--BEND--
        this.tremoloBar = new ToolItem(toolBar, SWT.CHECK);
        this.tremoloBar.setImage(SystemImages.EFFECT_TREMOLO_BAR);
        this.tremoloBar.addSelectionListener(TuxGuitar.instance().getAction(ChangeTremoloBarAction.NAME));   
        
        //--SLIDE--
        this.slide = new ToolItem(toolBar, SWT.CHECK);
        this.slide.setImage(SystemImages.EFFECT_SLIDE);
        this.slide.addSelectionListener(TuxGuitar.instance().getAction(ChangeSlideNoteAction.NAME));        
        
        //--HAMMER--
        this.hammer = new ToolItem(toolBar, SWT.CHECK);
        this.hammer.setImage(SystemImages.EFFECT_HAMMER);
        this.hammer.addSelectionListener(TuxGuitar.instance().getAction(ChangeHammerNoteAction.NAME));  

        
        //--SEPARATOR--
        new ToolItem(toolBar, SWT.SEPARATOR);        
        
        //--TRILL--
        this.trill = new ToolItem(toolBar, SWT.CHECK);
        this.trill.setImage(SystemImages.EFFECT_TRILL);
        this.trill.addSelectionListener(TuxGuitar.instance().getAction(ChangeTrillNoteAction.NAME));          

        //--TREMOLO PICKING--
        this.tremoloPicking = new ToolItem(toolBar, SWT.CHECK);
        this.tremoloPicking.setImage(SystemImages.EFFECT_TREMOLO_PICKING);
        this.tremoloPicking.addSelectionListener(TuxGuitar.instance().getAction(ChangeTremoloPickingAction.NAME));          
        
        
        
        //--PALM MUTE--
        this.palmMute = new ToolItem(toolBar, SWT.CHECK);
        this.palmMute.setImage(SystemImages.EFFECT_PALM_MUTE);
        this.palmMute.addSelectionListener(TuxGuitar.instance().getAction(ChangePalmMuteAction.NAME));        
        
        //--STACCATO
        this.staccato = new ToolItem(toolBar, SWT.CHECK);
        this.staccato.setImage(SystemImages.EFFECT_STACCATO);
        this.staccato.addSelectionListener(TuxGuitar.instance().getAction(ChangeStaccatoAction.NAME));         
        
        
        //--SEPARATOR--
        new ToolItem(toolBar, SWT.SEPARATOR);       
        
        //--TAPPING
        this.tapping = new ToolItem(toolBar, SWT.CHECK);
        this.tapping.setImage(SystemImages.EFFECT_TAPPING);
        this.tapping.addSelectionListener(TuxGuitar.instance().getAction(ChangeTappingAction.NAME));         

        //--SLAPPING
        this.slapping = new ToolItem(toolBar, SWT.CHECK);
        this.slapping.setImage(SystemImages.EFFECT_SLAPPING);
        this.slapping.addSelectionListener(TuxGuitar.instance().getAction(ChangeSlappingAction.NAME));        

        //--POPPING
        this.popping = new ToolItem(toolBar, SWT.CHECK);
        this.popping.setImage(SystemImages.EFFECT_POPPING);
        this.popping.addSelectionListener(TuxGuitar.instance().getAction(ChangePoppingAction.NAME));             
        
        //--SEPARATOR--
        new ToolItem(toolBar, SWT.SEPARATOR);
        
        //--FADE IN
        this.fadeIn = new ToolItem(toolBar, SWT.CHECK);
        this.fadeIn.setImage(SystemImages.EFFECT_FADE_IN);
        this.fadeIn.addSelectionListener(TuxGuitar.instance().getAction(ChangeFadeInAction.NAME));        
        
        this.loadProperties();
    }
 
    
    public void update(){    	
    	Note note = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
    	NoteEffect effect = ((note != null)?note.getEffect():new NoteEffect());
    	
        this.vibrato.setSelection(effect.isVibrato());
        this.bend.setSelection(effect.isBend());
        this.tremoloBar.setSelection(effect.isTremoloBar());
        this.deadNote.setSelection(effect.isDeadNote());
        this.slide.setSelection(effect.isSlide());
        this.hammer.setSelection(effect.isHammer());      
        this.ghostNote.setSelection(effect.isGhostNote());
        this.accentuatedNote.setSelection(effect.isAccentuatedNote());
        this.heavyAccentuatedNote.setSelection(effect.isHeavyAccentuatedNote());
        this.harmonicNote.setSelection(effect.isHarmonic());
        this.graceNote.setSelection(effect.isGrace());
        this.trill.setSelection(effect.isTrill());
        this.tremoloPicking.setSelection(effect.isTremoloPicking());
        this.palmMute.setSelection(effect.isPalmMute());
        this.staccato.setSelection(effect.isStaccato());
        this.tapping.setSelection(effect.isTapping());
        this.slapping.setSelection(effect.isSlapping());
        this.popping.setSelection(effect.isPopping()); 
        this.fadeIn.setSelection(effect.isFadeIn());
    }
    
    public void loadProperties(){        
        this.vibrato.setToolTipText(TuxGuitar.getProperty("effects.vibrato"));
        this.bend.setToolTipText(TuxGuitar.getProperty("effects.bend"));
        this.popping.setToolTipText(TuxGuitar.getProperty("effects.popping")); 
        this.deadNote.setToolTipText(TuxGuitar.getProperty("effects.deadnote"));
        this.slide.setToolTipText(TuxGuitar.getProperty("effects.slide"));
        this.hammer.setToolTipText(TuxGuitar.getProperty("effects.hammer"));        
        this.ghostNote.setToolTipText(TuxGuitar.getProperty("effects.ghostnote"));
        this.accentuatedNote.setToolTipText(TuxGuitar.getProperty("effects.accentuatednote"));
        this.heavyAccentuatedNote.setToolTipText(TuxGuitar.getProperty("effects.heavyaccentuatednote"));
        this.harmonicNote.setToolTipText(TuxGuitar.getProperty("effects.harmonic"));
        this.graceNote.setToolTipText(TuxGuitar.getProperty("effects.grace"));
        this.trill.setToolTipText(TuxGuitar.getProperty("effects.trill"));
        this.tremoloPicking.setToolTipText(TuxGuitar.getProperty("effects.tremolo-picking"));
        this.palmMute.setToolTipText(TuxGuitar.getProperty("effects.palm-mute"));        
        this.staccato.setToolTipText(TuxGuitar.getProperty("effects.staccato"));
        this.tapping.setToolTipText(TuxGuitar.getProperty("effects.tapping"));
        this.slapping.setToolTipText(TuxGuitar.getProperty("effects.slapping"));
        this.popping.setToolTipText(TuxGuitar.getProperty("effects.popping"));  
        this.fadeIn.setToolTipText(TuxGuitar.getProperty("effects.fade-in")); 
    }      
}

