package org.herac.tuxguitar.gui.printer;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;

public class PrintDocument{
	private Rectangle pageSize;
	private List pages;
	
	public PrintDocument(){
		this(new ArrayList());
	}
	
	public PrintDocument(List pages){
		this.pages = pages;
	}
	
	public List getPages() {
		return pages;
	}	
	
	public void makePage(ImageData data){
		this.pages.add(new PrintPage(count(),data));
	}

	public Rectangle getPageSize() {
		return pageSize;
	}

	public void setPageSize(Rectangle pageSize) {
		this.pageSize = pageSize;
	}
		
	public int count(){
		return this.pages.size();
	}
	
	public void clear(){
		this.pages.clear();
	}
}
