package org.herac.tuxguitar.gui.system.config.items;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;

public class ToolBarsOption extends Option{	
	private boolean changes;
	private List availableToolBars;
	private List customToolBars;
	private org.eclipse.swt.widgets.List availableList;
    private org.eclipse.swt.widgets.List customList;
    private Button addButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;
    
    public ToolBarsOption(ConfigEditor configEditor,ToolBar toolBar,final Composite parent){
        super(configEditor,toolBar,parent,TuxGuitar.getProperty("settings.config.toolbars"),SWT.FILL,SWT.FILL); 
        this.changes = false;
        this.loadToolBars();
    }

	public void createOption() {
		getToolItem().setText(TuxGuitar.getProperty("settings.config.toolbars"));	
		getToolItem().setImage(SystemImages.OPTION_TOOLBARS);
		getToolItem().addSelectionListener(this);
		
		Composite composite = new Composite(getComposite(),SWT.NONE);
		composite.setLayout(new GridLayout(2,false));
		composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		//left list
		Composite leftList = new Composite(composite, SWT.NONE);
		leftList.setLayout(new GridLayout());	
		leftList.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		availableList = new org.eclipse.swt.widgets.List(leftList,SWT.BORDER | SWT.V_SCROLL);
		availableList.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));					
		for(int i = 0;i < this.availableToolBars.size(); i ++){
			String name = (String)availableToolBars.get(i);
			availableList.add(TuxGuitar.getProperty(name));
		}		
		availableList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				checkButtons();
			}		
		});
		
		//right list
		Composite rightList = new Composite(composite, SWT.NONE);
		rightList.setLayout(new GridLayout());
		rightList.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		
		customList = new org.eclipse.swt.widgets.List(rightList,SWT.BORDER | SWT.V_SCROLL);
		customList.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));		
		customList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				checkButtons();
			}		
		});		
		
		//left buttons
		Composite leftButtons = new Composite(composite, SWT.NONE);
		leftButtons.setLayout(new GridLayout());	
		leftButtons.setLayoutData(new GridData(SWT.FILL,SWT.BOTTOM,true,true));
		
		addButton = new Button(leftButtons, SWT.PUSH);
		addButton.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		addButton.setText("Add");		
		addButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				addToolBar(availableList.getSelectionIndex());
			}		
		});		
		
		//right buttons		
		Composite rightButtons = new Composite(composite, SWT.NONE);
		rightButtons.setLayout(new GridLayout(3,false));
		rightButtons.setLayoutData(new GridData(SWT.FILL,SWT.BOTTOM,true,true));
		
		removeButton = new Button(rightButtons, SWT.PUSH);
		removeButton.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		removeButton.setText("Remove");
		removeButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				removeToolBar(customList.getSelectionIndex());
			}		
		});
		
		moveUpButton = new Button(rightButtons,SWT.ARROW | SWT.UP);	
		moveUpButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				moveUp(customList.getSelectionIndex());
			}		
		});
		
		moveDownButton = new Button(rightButtons,SWT.ARROW | SWT.DOWN);
		moveDownButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				moveDown(customList.getSelectionIndex());
			}		
		});		
		
		reloadList(-1);
	}		

	
	public  GridData makeButtonData(int horizontalAlignment,int minWith,int minHeight){   
    	GridData data = new GridData();    	
    	data.minimumWidth = minWith;
    	data.minimumHeight = minHeight;

    	data.horizontalAlignment = horizontalAlignment;
    	data.grabExcessHorizontalSpace = true;
    	    	
    	return data;
	}

	private void loadToolBars(){
		this.availableToolBars = TuxGuitar.instance().getItemManager().getAvailableToolBarNames();
		this.customToolBars = TuxGuitar.instance().getItemManager().getEnabledToolBars();
	}
	
	private void reloadList(int selection){
		this.customList.removeAll();
		
		Iterator it = this.customToolBars.iterator();
		while(it.hasNext()){
			String name = (String)it.next();
			this.customList.add(TuxGuitar.getProperty(name));
		}
		this.customList.select(selection);
		this.checkButtons();
	}
	
	private void checkButtons(){
		if(addButton != null && !addButton.isDisposed()){
			boolean enabled = false;
			int index = availableList.getSelectionIndex();
			if(index >= 0 && index < this.availableToolBars.size()){
				enabled = (!exists((String)this.availableToolBars.get(index)));
			}
			addButton.setEnabled(enabled);
		}
		if(removeButton != null && !removeButton.isDisposed()){
			int index = customList.getSelectionIndex();
			removeButton.setEnabled((index >= 0 && index < this.customToolBars.size()));
		}	
		if(moveUpButton != null && !moveUpButton.isDisposed()){
			int index = customList.getSelectionIndex();
			moveUpButton.setEnabled(index > 0 && index < this.customToolBars.size());
		}
		if(moveDownButton != null && !moveDownButton.isDisposed()){
			int index = customList.getSelectionIndex();
			moveDownButton.setEnabled(index >= 0 && index < (this.customToolBars.size() - 1));
		}		
	}
	
	private void addToolBar(int index){
		if(index >= 0 && index < this.availableToolBars.size()){
			String name = (String)this.availableToolBars.get(index);
			if(!exists(name)){
				this.customToolBars.add(name);
				this.reloadList((this.customToolBars.size() - 1));
				this.changes = true;
			}
		}
	}

	private void removeToolBar(int index){
		if(index >= 0 && index < this.customToolBars.size()){
			this.customToolBars.remove(index);
			this.reloadList((this.customToolBars.size() > index)?index:this.customToolBars.size() - 1);
			this.changes = true;
		}
	}	
	
	private void moveUp(int index){
		if(index > 0 && index < this.customToolBars.size()){
			String name = (String)this.customToolBars.get(index);
			this.customToolBars.remove(index);
			this.customToolBars.add((index - 1),name);
			this.reloadList((index - 1));
			this.changes = true;
		}
	}		

	private void moveDown(int index){
		if(index >= 0 && index < (this.customToolBars.size() - 1)){
			String name = (String)this.customToolBars.get(index);
			this.customToolBars.remove(index);
			this.customToolBars.add((index + 1),name);
			this.reloadList((index + 1));
			this.changes = true;
		}		
	}		

	private boolean exists(String name){
		Iterator it = this.customToolBars.iterator();
		while(it.hasNext()){
			String currentName = (String)it.next();
			if(currentName.equals(name)){
				return true;
			}
		}
		return false;
	}
	
	public void updateConfig() {
		TuxGuitar.instance().getItemManager().saveToolBars(this.customToolBars);
	}
	
    public void applyConfig(boolean force){
    	if(this.changes || force){
    		TuxGuitar.instance().loadToolBars();
    	}
    }
}
