package org.herac.tuxguitar.gui.system.keybindings.xml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.keybindings.KeyBinding;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class KeyBindingReader {
	private static final String SHORTCUT_TAG = "shortcut";
	private static final String ACTION_ATTRIBUTE = "action";
	private static final String KEYS_ATTRIBUTE = "keys";
	
    public static Map getKeyBindings(String fileName) {
    	Map bindings = null;
    	try{
    		File file = new File(fileName);
        
    		if (file.exists()){
    			Document doc = getDocument(file);
    			bindings = getBindings(doc.getFirstChild());
    		}
    	}catch(Exception e){
    		e.printStackTrace();
    	}
        return bindings;
    }
    
    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(file);
        } catch (SAXException sxe) {
            sxe.printStackTrace();
        } catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return document;
    }

    /**
     * Read shortcuts from xml file
     * 
     * @param shortcutsNode
     * @return
     */
    private static Map getBindings(Node shortcutsNode){
    	Map bindings = new HashMap();

        NodeList nodeList = shortcutsNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node child = nodeList.item(i);
            String nodeName = child.getNodeName();

            if (nodeName.equals(SHORTCUT_TAG)) {
            	NamedNodeMap params = child.getAttributes();

            	String key = params.getNamedItem(KEYS_ATTRIBUTE).getNodeValue();
            	String action = params.getNamedItem(ACTION_ATTRIBUTE).getNodeValue();
            	
            	if (key == null || action == null || key.trim().equals("") || action.trim().equals("")){
            		throw new RuntimeException("Invalid KeyBinding file format.");
            	}

                bindings.put(KeyBinding.parse(key),TuxGuitar.instance().getAction(action));
            }

        }

        return bindings;
    }
}
