/*
 * Created on 28-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.table;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.herac.tuxguitar.gui.editors.TablatureEditor;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongTable extends Composite{
    private TablatureEditor editor;
    private SashForm form;   
    private SongTableColumn[] columns;
    
    public SongTable(Composite parent,int columns,TablatureEditor editor) {
        super(parent,SWT.NONE);        
        this.editor = editor;                   
	    this.setLayout(makeLayout());
	    this.setLayoutData(new GridData(SWT.FILL,SWT.TOP,true,false,0,0));	  	

	    this.form = new SashForm(this,SWT.HORIZONTAL);	  	    
	    this.form.setLayoutData(new GridData(SWT.FILL,SWT.TOP,true,false,0,0));	 
	    this.form.SASH_WIDTH = 1;	    
	    
	    this.makeColumns(columns);
    }
    
    private GridLayout makeLayout(){
		GridLayout layout = new GridLayout();
		layout.marginTop = 0;
		layout.marginBottom = 0;
		layout.marginLeft = 0;
		layout.marginRight = 0;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.horizontalSpacing = 0;
		layout.verticalSpacing = 0;
		return layout;
    }
    
    public void makeColumns(int columns){
        this.columns = new SongTableColumn[columns];
        for(int i = 0; i< columns;i++){
            this.columns[i] = new SongTableColumn(this.form);
        }
    }
    
    public SongTableColumn getColumn(int index){
        return this.columns[index];
    }
    
    public void  clearColumnsAfter(int index){
        for(int i = 0; i< this.columns.length;i++){            
            this.columns[i].clearAfter(index);
        }
    }
       
    public int getItemCount(){
    	return getColumn(0).getItemCount();
    }
    
    public int getHeaderHeight(){
    	return getColumn(0).getHeaderHeight();
    }
    
    public void layout(){
        super.layout();
        for(int i = 0; i< this.columns.length;i++){            
            this.columns[i].layout();
        }
        this.form.layout();
    }

    public void setWeights(int[] weights){
        this.form.setWeights(weights);        
    }
 
    
    public class SongTableColumn extends Composite{
        private Button header;
        
        public SongTableColumn(Composite parent){
    	    super(parent,SWT.NONE);    	        	        
    	    this.setLayout(makeLayout());    	    	    	    
    	    this.header = new Button(this,SWT.LEFT);    	    
    	    this.header.setLayoutData(new GridData(SWT.FILL,SWT.TOP,true,false,0,0));
        } 
        
        private GridLayout makeLayout(){
    		GridLayout layout = new GridLayout();
    		layout.marginTop = 0;
    		layout.marginBottom = 0;
    		layout.marginLeft = 0;
    		layout.marginRight = 0;
    		layout.marginHeight = 0;
    		layout.marginWidth = 0;
    		layout.horizontalSpacing = 0;
    		layout.verticalSpacing = 0;
    		return layout;
        }
        
        public void setName(String name){
            this.header.setText(name);
        }
        
        public int getItemCount(){
            return getChildren().length - 1;
        }

        public int getItemHeight(){
            Control[] controls = getChildren();
            return controls[1].getBounds().height;
        }
        
        public Control getItem(int index){
            Control[] controls = getChildren();
            return controls[index + 1];
        }        
        
        public int getHeaderHeight(){
            return this.header.getBounds().height;
        }
        
        public boolean isEmpty(){
        	return getChildren().length <= 1;
        }

        public void clearAfter(int index){
            Control[] controls = getChildren();
            for(int i = (index + 1);i < controls.length;i++){
                controls[i].dispose();
            }
        }
    }
    

}
