package org.herac.tuxguitar.gui.undo.undoables.measure;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;

public class UndoableMeasureGeneric implements UndoableEdit{
	private int doAction;
	private int trackNumber;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;		
	private Measure undoMeasure;
	private Measure redoMeasure;
	
	private UndoableMeasureGeneric(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		this.replace(this.redoMeasure);	
		this.redoCaret.update();
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}		        
		this.replace(this.undoMeasure);		
		this.undoCaret.update();
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
   
    private void replace(Measure replace){
		SongTrackCoords track = getCaret().getSongCoords().getTrack(trackNumber);    
		if(track != null && replace != null){
			MeasureHeader header = TuxGuitar.instance().getSongManager().getMeasureHeader(replace.getNumber());
			Measure measure = (Measure)replace.clone(header);
			measure = TuxGuitar.instance().getSongManager().getTrackManager().replaceMeasure(track.getTrack(),measure);
			TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false);    			
		}	
    }
    
    public static UndoableMeasureGeneric startUndo(){
    	UndoableMeasureGeneric undoable = new UndoableMeasureGeneric();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
    	undoable.undoCaret = new UndoableCaretHelper();    	
    	undoable.undoMeasure = (Measure)caret.getMeasureCoords().getMeasure().clone((MeasureHeader)caret.getMeasureCoords().getMeasure().getHeader().clone());    	    	
    	return undoable;
    }
    
    public UndoableMeasureGeneric endUndo(){    
    	Caret caret = getCaret(); 
    	this.redoCaret = new UndoableCaretHelper();
    	this.redoMeasure = (Measure)caret.getMeasureCoords().getMeasure().clone((MeasureHeader)caret.getMeasureCoords().getMeasure().getHeader().clone());	
		return this;
    }
    
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
   
}
