/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "g_local.h"
#include "g_gametypes.h"

#ifdef MIDAIR

//==================
//G_Gametype_MIDAIR_ScoreboardMessage
//==================
char *G_Gametype_MIDAIR_ScoreboardMessage( edict_t *ent, edict_t *killer )
{
	char		entry[MAX_TOKEN_CHARS];
	size_t		len;
	int			i;
	edict_t		*e;

	//fixed layout scheme id
	Q_snprintfz(scoreboardString, sizeof(scoreboardString), "scb \"&dms " ); 
	len = strlen(scoreboardString);
	*entry = 0;	// wsw : aiwa : fix unitialized value heisenbug
	
	//players
	for( i = 0; teamlist[TEAM_PLAYERS].playerIndices[i] != -1; i++ )
	{
		e = game.edicts + teamlist[TEAM_PLAYERS].playerIndices[i];
		//player tab entry
		*entry = 0;
		Q_snprintfz(entry, sizeof(entry), "&p %i %i %i %i ",
			PLAYERNUM(e),
			match.scores[PLAYERNUM(e)].score,
			e->r.client->r.ping > 999 ? 999 : e->r.client->r.ping,
			match.ready[PLAYERNUM(e)]
			);
		
		if (SCOREBOARD_MSG_MAXSIZE - len > strlen(entry)) {
			Q_strncatz(scoreboardString, entry, sizeof(scoreboardString));
			len = strlen(scoreboardString);
		}
	}

	G_ScoreboardMessage_AddSpectators();

	// add player stats (all weapon weak/strong 0..99) to scoreboard message
	G_ScoreboardMessage_AddPlayerStats( ent );

	// add closing quote
	if( SCOREBOARD_MSG_MAXSIZE - len > strlen(entry) ) {
		Q_strncatz( scoreboardString, "\"", sizeof(scoreboardString) );
		len = strlen(scoreboardString);
	}
	return scoreboardString;
}

qboolean G_Gametype_MIDAIR_ClientRespawn( edict_t *self )
{
	int index, i;
	edict_t *spawnpoint;
	vec3_t spawn_origin, spawn_angles;
	gclient_t *client;
	client_respawn_t resp;
	client_teamchange_t teamchange;
	client_persistant_t pers;
	char userinfo[MAX_INFO_STRING];
	weapon_info_t *weaponinfo;
	int ammocount, weakammocount;

	self->r.svflags &= ~SVF_NOCLIENT;

	GClip_UnlinkEntity( self );

	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
	SelectSpawnPoint( self, &spawnpoint, spawn_origin, spawn_angles, 0 );

	index = self-game.edicts-1;
	client = self->r.client;

	// deathmatch wipes most client data every spawn
	resp = client->resp;
	teamchange = client->teamchange;
	pers = client->pers;
	memcpy( userinfo, client->pers.userinfo, sizeof(userinfo) );
	memset( client, 0, sizeof(*client) );
	client->resp = resp;
	client->teamchange = teamchange;
	client->pers = pers;

	self->deadflag = DEAD_NO;
	ClientUserinfoChanged( self, userinfo );

	// clear entity values
	self->groundentity = NULL;
	self->r.client = &game.clients[index];
	self->takedamage = DAMAGE_AIM;
	self->movetype = MOVETYPE_PLAYER;
	self->think = player_think;
	self->pain = player_pain;
	self->die = player_die;
	self->viewheight = playerbox_stand_viewheight;
	self->r.inuse = qtrue;
	self->mass = 200;
	self->r.solid = SOLID_BBOX;
	self->air_finished = level.time + (12*1000);
	self->r.clipmask = MASK_PLAYERSOLID;
	self->waterlevel = 0;
	self->watertype = 0;
	self->flags &= ~FL_NO_KNOCKBACK;
	self->r.svflags &= ~SVF_CORPSE;
	//MbotGame[start]

	if( self->ai.type == AI_ISBOT ) {
		self->think = AI_Think;
		self->classname = "bot";
	} else if( self->r.svflags & SVF_FAKECLIENT ) {
		self->classname = "fakeclient";//[end]
	} else {
		self->classname = "player";
	}

	VectorCopy( playerbox_stand_mins, self->r.mins );
	VectorCopy( playerbox_stand_maxs, self->r.maxs );
	VectorClear( self->velocity );
	VectorClear( self->avelocity );

	// clear playerstate values
	memset( &self->r.client->ps, 0, sizeof(client->ps) );

	VectorCopy( spawn_origin, client->ps.pmove.origin );

	client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;

	client->ps.POVnum = ENTNUM(self);

	// clear entity state values
	self->s.type = ET_PLAYER;
	self->s.effects = 0;
	self->s.light = 0;

	// modelindex and skinnum are set at calling to update userinfo
	self->s.modelindex2 = 0;

	//splitmodels: clean up animations
	self->pmAnim.anim_priority[LOWER] = ANIM_BASIC;
	self->pmAnim.anim_priority[UPPER] = ANIM_BASIC;
	self->pmAnim.anim_priority[HEAD] = ANIM_BASIC;

	self->pmAnim.anim[LOWER] = LEGS_IDLE;
	self->pmAnim.anim[UPPER] = TORSO_STAND;
	self->pmAnim.anim[HEAD] = ANIM_NONE;

	self->fall_velocity = 0;
	self->fall_fatal = qfalse;

	self->s.weapon = 0;
	self->s.frame = 0;
	VectorCopy( spawn_origin, self->s.origin );
	VectorCopy( self->s.origin, self->s.old_origin );

	// set angles
	self->s.angles[PITCH] = 0;
	self->s.angles[YAW] = spawn_angles[YAW];
	self->s.angles[ROLL] = 0;
	VectorCopy( self->s.angles, client->ps.viewangles );

	// set the delta angle
	for( i = 0; i < 3; i++ )
		client->ps.pmove.delta_angles[i] = ANGLE2SHORT(self->s.angles[i]) - client->pers.cmd_angles[i];

	//if invalid join spectator
	if( self->s.team < 0 || self->s.team >= GS_MAX_TEAMS )
		self->s.team = TEAM_SPECTATOR;

	//don't put spectators in the game
	if( self->s.team == TEAM_SPECTATOR )
	{
		self->deadflag = DEAD_NO;
		self->movetype = MOVETYPE_NOCLIP;
		self->r.solid = SOLID_NOT;
		self->r.svflags |= SVF_NOCLIENT;
		GClip_LinkEntity( self );
	}
	else
	{
		if( KillBox(self) )
		{	// could't spawn in?
		}

		GClip_LinkEntity(self);

		// add a teleportation effect
		G_SpawnTeleportEffect( self );
	}

	self->s.teleported = qtrue;

	// hold in place briefly
	self->r.client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
	self->r.client->ps.pmove.pm_time = 14;

	BOT_Respawn( self ); //MbotGame

	// wsw: pb set default max health
	self->max_health = 100;
	self->health = self->max_health;

	//give default items
	memset( &self->r.client->inventory, 0, sizeof(self->r.client->inventory) );
	self->r.client->inventory[WEAP_ROCKETLAUNCHER] = 1;
	self->r.client->inventory[AMMO_ROCKETS] = 10;

	G_UseTargets( spawnpoint, self );

	for( i = WEAP_TOTAL - 1; i >= WEAP_GUNBLADE; i-- )
	{
		if( i == WEAP_SHOCKWAVE ) // FIXME!!!
			continue;

		if( !self->r.client->inventory[i] )
			continue;

		if( g_select_empty->integer )
			break;

		weaponinfo = &gs_weaponInfos[i];

		if( weaponinfo->firedef->usage_count && weaponinfo->firedef->ammo_id )
			ammocount = self->r.client->inventory[weaponinfo->firedef->ammo_id];
		else
			ammocount = weaponinfo->firedef->usage_count;

		if( weaponinfo->firedef_weak->usage_count && weaponinfo->firedef_weak->ammo_id )
			weakammocount = self->r.client->inventory[weaponinfo->firedef_weak->ammo_id];
		else
			weakammocount = weaponinfo->firedef_weak->usage_count;

		if( ammocount >= weaponinfo->firedef->usage_count || weakammocount >= weaponinfo->firedef_weak->usage_count)
			break;
	}
	self->r.client->latched_weapon = i;

	// FIXME: forcing RL to be used if available
	if( self->r.client->inventory[WEAP_ROCKETLAUNCHER] )
	{
		if( g_select_empty->integer )
			self->r.client->latched_weapon = WEAP_ROCKETLAUNCHER;

		weaponinfo = &gs_weaponInfos[WEAP_ROCKETLAUNCHER];

		if( weaponinfo->firedef->usage_count && weaponinfo->firedef->ammo_id )
			ammocount = self->r.client->inventory[weaponinfo->firedef->ammo_id];
		else
			ammocount = weaponinfo->firedef->usage_count;

		if( weaponinfo->firedef_weak->usage_count && weaponinfo->firedef_weak->ammo_id )
			weakammocount = self->r.client->inventory[weaponinfo->firedef_weak->ammo_id];
		else
			weakammocount = weaponinfo->firedef_weak->usage_count;

		if( ammocount >= weaponinfo->firedef->usage_count || weakammocount >= weaponinfo->firedef_weak->usage_count)
			self->r.client->latched_weapon = WEAP_ROCKETLAUNCHER;
	}

	ChangeWeapon( self );
	self->r.client->weaponstate.status = WEAPON_ACTIVATING;
	self->r.client->weaponstate.nexttime = WEAPON_RESPAWN_DELAY;

	return qtrue;
}

//=================
//G_Gametype_MIDAIR_ClientHealthRule
//=================
static void G_Gametype_MIDAIR_ClientHealthRule( void )
{
	edict_t		*e;
	
	// if player has more than 300 health he gets a quad and the life resets to 300
	for( e = game.edicts+1; PLAYERNUM(e) < game.maxclients; e++ )
	{
		if (!e->r.inuse)
			continue;
		
		if( e->health > 250 ) {
			e->health -= game.snapFrameTime;
			if( e->health < 250 )
				e->health = 250;
		}

		if( e->health < 200 && (e->r.client->quad_timeout > level.time) )
		{
			//e->r.client->quad_timeout = level.time;
		} 
		else if( e->health >= 200 && (e->r.client->quad_timeout < level.time) ) 
		{
			//give a quad
			if( game.items[POWERUP_QUAD] != NULL ) 
			{
				e->r.client->inventory[POWERUP_QUAD]++;
				G_UseItem( e, game.items[POWERUP_QUAD] );
				G_PrintMsg( NULL, "%s %sgot a QUAD bonus!%s\n", e->r.client->pers.netname, S_COLOR_RED, S_COLOR_WHITE );
			}

			// reset health to 100
			e->health = 100;
		}
	}
}

//=================
//G_Gametype_MIDAIR_CheckRules
//=================
void G_Gametype_MIDAIR_CheckRules( void )
{
	if( match.state >= MATCH_STATE_POSTMATCH )
		return;

	if( game.gametype != GAMETYPE_MIDAIR )
		return;

	G_Gametype_MIDAIR_ClientHealthRule();
	
	if( G_Match_GenericCountDownAnnounces() ) { // true once a second
	}
}

#endif // MIDAIR
