/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "g_local.h"
#include "g_gametypes.h"


typedef struct {
	int	picked_powerups[GS_MAX_TEAMS];

	// to add:
	//int	helpBonus;
	//int	giveBonus;
}tdm_stats_t;

tdm_stats_t	tdmgame;


//=================
//G_Gametype_TDM_SetUpMatch
//=================
void G_Gametype_TDM_SetUpMatch( void )
{
	G_Gametype_GENERIC_SetUpMatch();

	//clear team stats
	memset( &tdmgame, 0, sizeof(tdm_stats_t) );
}

//==================
//G_Gametype_TDM_ScoreboardMessage
//==================
char *G_Gametype_TDM_ScoreboardMessage( edict_t *ent, edict_t *killer )
{
	char		entry[MAX_TOKEN_CHARS];
	size_t		len;
	int			i, team;
	edict_t		*e;

	//fixed layout scheme id
	Q_snprintfz( scoreboardString, sizeof(scoreboardString), "scb \"&tdms " ); 
	len = strlen(scoreboardString);
	*entry = 0;	// wsw : aiwa : fix unitialized value heisenbug
	
	//it's sending the players in score order
	for( team = TEAM_ALPHA; team < TEAM_ALPHA + g_maxteams->integer; team++ )
	{
		//team tab entry
		*entry = 0;
		Q_snprintfz( entry, sizeof(entry), "&t %i %i ",
			team,
			teamlist[team].teamscore );
		
		if( SCOREBOARD_MSG_MAXSIZE - len > strlen(entry) ) {
			Q_strncatz(scoreboardString, entry, sizeof(scoreboardString));
			len = strlen(scoreboardString);
		}
		
		for( i = 0; teamlist[team].playerIndices[i] != -1; i++ )
		{
			e = game.edicts + teamlist[team].playerIndices[i];
			
			//player tab entry
			*entry = 0;
			Q_snprintfz( entry, sizeof(entry), "&p %i %i %i %i %i %i %i %i %i ",
				PLAYERNUM(e),
				match.scores[PLAYERNUM(e)].score,
				match.scores[PLAYERNUM(e)].kills,
				match.scores[PLAYERNUM(e)].deaths,
				match.scores[PLAYERNUM(e)].suicides,
				match.scores[PLAYERNUM(e)].teamfrags,
				e->r.client->r.ping > 999 ? 999 : e->r.client->r.ping,
				match.ready[PLAYERNUM(e)],
				e->r.client->is_coach
				);
			
			if( SCOREBOARD_MSG_MAXSIZE - len > strlen(entry) ) {
				Q_strncatz( scoreboardString, entry, sizeof(scoreboardString) );
				len = strlen(scoreboardString);
			}
		}
	}

	G_ScoreboardMessage_AddSpectators();

	// add player stats (all weapon weak/strong 0..99) to scoreboard message
	G_ScoreboardMessage_AddPlayerStats( ent );

	// add closing quote
	if( SCOREBOARD_MSG_MAXSIZE - len > strlen(entry) ) {
		Q_strncatz( scoreboardString, "\"", sizeof(scoreboardString) );
		len = strlen(scoreboardString);
	}
	return scoreboardString;
}


//==================
//G_Gametype_TDM_FragBonuses
//==================
void G_Gametype_TDM_FragBonuses( edict_t *targ, edict_t *inflictor, edict_t *attacker, int mod )
{
	if( targ->s.team < TEAM_ALPHA || targ->s.team >= GS_MAX_TEAMS )
		return; // whoever died isn't on a team

	// add frag to scores
	
	if( !attacker->r.client ) // killed by the world
	{
		if( attacker == world && targ->r.client ) 
		{
			if( mod == MOD_FALLING ) //should have cratereds++
				match.scores[PLAYERNUM(targ)].suicides++;
			
			match.scores[PLAYERNUM(targ)].deaths++;
			match.scores[PLAYERNUM(targ)].score--;
			teamlist[targ->s.team].teamplayerscores--;
			teamlist[targ->s.team].teamscore--;
		}
		return;
	}
	
	//selffrag or teamfrag
	if( targ->s.team == attacker->s.team ) { 
		match.scores[PLAYERNUM(attacker)].score--;
		teamlist[attacker->s.team].teamplayerscores--;
		teamlist[attacker->s.team].teamscore--;
		if( targ == attacker )
			match.scores[PLAYERNUM(attacker)].suicides++;
		else
			match.scores[PLAYERNUM(attacker)].teamfrags++;
	} else {
		match.scores[PLAYERNUM(attacker)].score++;
		teamlist[attacker->s.team].teamplayerscores++;
		teamlist[attacker->s.team].teamscore++;
		match.scores[PLAYERNUM(attacker)].kills++;
	}

	if (!targ->r.client) //can't count deaths on non-clients
		return;

	match.scores[PLAYERNUM(targ)].deaths++;
}

//=================
//G_Gametype_TDM_CheckRules
//=================
void G_Gametype_TDM_CheckRules( void )
{
	if( match.state >= MATCH_STATE_POSTMATCH )
		return;

	if( game.gametype != GAMETYPE_TDM )
		return;

	G_GameType_ClientHealthRule();
	//G_GameType_ClientArmorDecayRule();
	G_Teams_UpdateTeamInfoMessages();

	if( G_Match_GenericCountDownAnnounces() ) { // true once a second
	}
}








