/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// gs_weapondefs.c	-	hard coded weapon definitions

#include "../game/wsw_shared.h"

#include "../game/q_shared.h"
#include "gs_public.h"

#define INSTANT 0

firedef_t ammoFireDefs[] =
{
#ifdef GUNBLADEAUTOCHARGE
	{
		WEAP_GUNBLADE,
		FIRE_MODE_STRONG,
		AMMO_CELLS,
		1,						// ammo usage per shot
		1,						// projectiles fired each shot
		
		//timings (in msecs)
		50,						// weapon up frametime
		50,						// weapon down frametime
		400,						// reload frametime
		0,						// cooldown frametime
		0, 						// max powering up time
		5000,						// projectile timeout
		
		//damages
		90,						// damage
		90,						// knockback
		100,						// splash radius
		8,						// splash minimum damage
		
		//projectile def
		3000,						// speed
		0,						// h spread
		0,						// v spread
		
		//ammo
		10,					// pickup amount
		100					// max amount
	},
#else
	{
		WEAP_GUNBLADE,
		FIRE_MODE_STRONG,
		AMMO_CELLS,
		20,						// ammo usage per shot
		1,						// projectiles fired each shot
		
		//timings (in msecs)
		50,						// weapon up frametime
		50,						// weapon down frametime
		250,						// reload frametime
		0,						// cooldown frametime
		2000,						// max powering up time
		5000,						// projectile timeout
		
		//damages
		60,						// damage
		60,						// knockback
		80,						// splash radius
		8,						// splash minimum damage
		
		//projectile def
		3000,						// speed
		0,						// h spread
		0,						// v spread
		
		//ammo
		10,					// pickup amount
		100					// max amount
	},
#endif
	{
		WEAP_GUNBLADE,
		FIRE_MODE_WEAK,
		AMMO_WEAK_GUNBLADE,
		0,					// ammo usage per shot
		0,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		800,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		64,					// projectile timeout  / projectile range for instant weapons
		
		//damages
		40,					// damage
		50,					// knockback
		0,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		0,					// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		0,					// pickup amount
		0					// max amount
	},

	{
		WEAP_SHOCKWAVE,
		FIRE_MODE_STRONG,
		AMMO_WAVES,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		1000,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		3000,					// projectile timeout
		
		//damages
		0,					// damage
		0,					// knockback
		50,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		1000,					// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		5,					// pickup amount
		5					// max amount
	},

	{
		WEAP_SHOCKWAVE,
		FIRE_MODE_WEAK,
		AMMO_WEAK_WAVES,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		1000,				// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		3000,				// projectile timeout
		
		//damages
		0,					// damage
		0,					// knockback
		50,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		1000,				// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		10,					// pickup amount
		10					// max amount
	},

	{
		WEAP_RIOTGUN,
		FIRE_MODE_STRONG,
		AMMO_SHELLS,
		1,					// ammo usage per shot
		16,					//20*5=100	// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		850,				// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		8192,				// projectile timeout / projectile range for instant weapons
		
		//damages
		5,					// damage
		8,					// knockback
		0,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		INSTANT,				// speed
		1300,					// h spread
		1300,					// v spread
		
		//ammo
		5,					// pickup amount
		10					// max amount
	},

	{
		WEAP_RIOTGUN,
		FIRE_MODE_WEAK,
		AMMO_WEAK_SHELLS,
		1,					// ammo usage per shot
		14,			//15*5=75	// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		850,				// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		8192,				// projectile timeout / projectile range for instant weapons
		
		//damages
		5,					// damage
		6,					// knockback
		0,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		INSTANT,				// speed
		1450,					// h spread
		1450,					// v spread
		
		//ammo
		10,					// pickup amount
		25					// max amount
	},

	{
		WEAP_GRENADELAUNCHER,
		FIRE_MODE_STRONG,
		AMMO_GRENADES,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		800,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		2000,					// projectile timeout
		
		//damages
		110,					// damage
		120,					// knockback
		150,					// splash radius
		20,					// splash minimum damage
		
		//projectile def
		1000,					// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		5,					// pickup amount
		10					// max amount
	},

	{
		WEAP_GRENADELAUNCHER,
		FIRE_MODE_WEAK,
		AMMO_WEAK_GRENADES,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		800,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		2000,					// projectile timeout
		
		//damages
		100,					// damage
		80,					// knockback
		150,					// splash radius
		5,					// splash minimum damage
		
		//projectile def
		1000,					// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		10,					// pickup amount
		15					// max amount
	},

	{
		WEAP_ROCKETLAUNCHER,
		FIRE_MODE_STRONG,
		AMMO_ROCKETS,
		1,								// ammo usage per shot
		1,								// projectiles fired each shot
		
		//timings (in msecs)
		50,								// weapon up frametime
		50,								// weapon down frametime
		800,								// reload frametime
		0,								// cooldown frametime
		0,								// max powering up time
		10000,								// projectile timeout
		
		//damages
		95,									// damage
		100,								// knockback
		120,								// splash radius
		10,									// splash minimum damage
		
		//projectile def
		1100,								// speed
		0,								// h spread
		0,								// v spread
		
		//ammo
		5,					// pickup amount
		5					// max amount
	},

	{
		WEAP_ROCKETLAUNCHER,
		FIRE_MODE_WEAK,
		AMMO_WEAK_ROCKETS,
		1,								// ammo usage per shot
		1,								// projectiles fired each shot
		
		//timings (in msecs)
		50,								// weapon up frametime
		50,								// weapon down frametime
		800,								// reload frametime
		0,								// cooldown frametime
		0,								// max powering up time
		10000,				// projectile timeout
		
		//damages
		80,								// damage
		95,								// knockback
		120,								// splash radius
		8,								// splash minimum damage
		
		//projectile def
		1100,								// speed
		0,								// h spread
		0,								// v spread
		
		//ammo
		10,					// pickup amount
		25					// max amount
	},

	{
		WEAP_PLASMAGUN,
		FIRE_MODE_STRONG,
		AMMO_PLASMA,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		100,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		5000,					// projectile timeout
		
		//damages
		14,					// damage
		28,					// knockback
		40,					// splash radius
		5,					// splash minimum damage
		
		//projectile def
		1700,					// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		25,					// pickup amount
		50					// max amount
	},

	{
		WEAP_PLASMAGUN,
		FIRE_MODE_WEAK,
		AMMO_WEAK_PLASMA,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		100,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		5000,					// projectile timeout
		
		//damages
		11,					// damage
		19,					// knockback
		20,					// splash radius
		1,					// splash minimum damage
		
		//projectile def
		1700,					// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		50,					// pickup amount
		75					// max amount
	},

	{
		WEAP_LASERGUN,
		FIRE_MODE_STRONG,
		AMMO_LASERS,
		1,						// ammo usage per shot
		1,						// projectiles fired each shot
		
		//timings (in msecs)
		50,						// weapon up frametime
		50,						// weapon down frametime
		50,						// reload frametime
		0,						// cooldown frametime
		0,						// max powering up time
		590,						// projectile timeout / projectile range for instant weapons
		
		//damages
		7,						// damage
		9,						// knockback
		0,						// splash radius
		0,						// splash minimum damage
		
		//projectile def
		INSTANT,					// speed
		0,						// h spread
		0,
		
		//ammo
		40,					// pickup amount
		120					// max amount
	},

	{
		WEAP_LASERGUN,
		FIRE_MODE_WEAK,
		AMMO_WEAK_LASERS,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		50,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		590,					// projectile timeout / projectile range for instant weapons
		
		//damages
		7,					// damage
		9,					// knockback
		0,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		INSTANT,				// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		80,					// pickup amount
		120					// max amount
	},

	{
		WEAP_ELECTROBOLT,
		FIRE_MODE_STRONG,
		AMMO_BOLTS,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		1300,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		1024,					// instant block range (weak def timeout for projectile part).
		
		//damages
		65,					// damage
		115,				// knockback
		0,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		INSTANT,				// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		5,					// pickup amount
		5					// max amount
	},

	{
		WEAP_ELECTROBOLT,
		FIRE_MODE_WEAK,
		AMMO_WEAK_BOLTS,
		1,					// ammo usage per shot
		1,					// projectiles fired each shot
		
		//timings (in msecs)
		50,					// weapon up frametime
		50,					// weapon down frametime
		1300,					// reload frametime
		0,					// cooldown frametime
		0,					// max powering up time
		5000,					// projectile timeout
		
		//damages
		65,					// damage
		115,				// knockback
		0,					// splash radius
		0,					// splash minimum damage
		
		//projectile def
		6000,					// speed
		0,					// h spread
		0,					// v spread
		
		//ammo
		5,					// pickup amount
		10					// max amount
	},

	{ 0 }
};
