#include "LB_ClientORBInitializer.h"
#include "LB_ClientRequestInterceptor.h"

#include "tao/ORB_Constants.h"

ACE_RCSID (LoadBalancing,
           LB_ClientORBInitializer,
           "LB_ClientORBInitializer.cpp,v 1.3 2005/02/18 09:07:08 jwillemsen Exp")

void
TAO_LB_ClientORBInitializer::pre_init (
    PortableInterceptor::ORBInitInfo_ptr
    ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
}

void
TAO_LB_ClientORBInitializer::post_init (
    PortableInterceptor::ORBInitInfo_ptr info
    ACE_ENV_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  PortableInterceptor::ClientRequestInterceptor_ptr tmp;
  ACE_NEW_THROW_EX (tmp,
                    TAO_LB_ClientRequestInterceptor,
                    CORBA::NO_MEMORY (
                      CORBA::SystemException::_tao_minor_code (
                        TAO::VMCID,
                        ENOMEM),
                      CORBA::COMPLETED_NO));
  ACE_CHECK;

  PortableInterceptor::ClientRequestInterceptor_var client_interceptor = tmp;

  info->add_client_request_interceptor (client_interceptor.in ()
                                        ACE_ENV_ARG_PARAMETER);
  ACE_CHECK;
}
