#ifndef guard_value_traits_hpp
#define guard_value_traits_hpp
/**
 * @file
 *
 * @brief Implement the element manipulation traits for types with
 * value-like semantics.
 *
 * value_traits.hpp,v 1.2 2004/09/25 13:55:51 coryan Exp
 *
 * @author Carlos O'Ryan
 */

#include <algorithm>

namespace TAO
{
namespace details
{

template<typename T, bool dummy>
struct value_traits
{
  typedef T value_type;
  typedef T const const_value_type;

  inline static void zero_range(
      value_type * /* begin */, value_type * /* end */)
  {}

  inline static void initialize_range(
      value_type * /* begin */, value_type * /* end */)
  {}

  inline static void copy_range(
      value_type * begin, value_type * end, value_type *dst)
  {
    std::copy(begin, end, dst);
  }
};

} // namespace details
} // namespace CORBA

#endif // guard_value_traits_hpp
