# ----------------------------------------------------------
# AdvaS Advanced Search 
# module for working with category trees
#
# (C) 2002 - 2005 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
# ----------------------------------------------------------

# changed 2004-11-16

import string

def category_make_tree (category_string):
	"convert a category string in a category tree"

	tree = []
	id = 1

	# create ROOT node
	root_node = category_make_node ("ROOT")
	root_node["up"] = 0
	root_node["root"] = 1
	tree.append(root_node)
	
	splitted_string = category_split_string(category_string)
	for item in splitted_string:
		# create node
		node = category_make_node (item)
	
		# link previous node and current node ... if not root node
		node["up"] = id - 1
		tree[id - 1]["next"] = [id]
		
		# add node to tree
		tree.append(node)
		id = id + 1
	# end for

	return tree

def category_make_node (node_name):
	"create an empty category node"

	node = {
		"name": node_name,
		"next": [],
		"up"  : 0,
		"root": 0
	}
	return node

def category_split_string (category_string):
	"split the category string into several chunks"

	levels = string.split(category_string, "/")
	return levels

def category_is_root_node (node):
	"checks a node for being a root node"

	if(node["root"] == 1):
		return 1
	else:
		return 0
	# end if

def category_is_leaf_node (node):
	"checks a node for being a leaf node"

	if(node["next"] == []):
		return 1
	else:
		return 0
	# end if

def category_get_root_node (tree):
	"returns the root node of the given tree"

	for i in range(len(tree)):
		node = tree[i]
		if(category_is_root_node(node)):
			return node
		# end if
	# end for

	return -1

# -- unfinished / testing --

def category_merge_trees (tree_1, tree_2):
	"extends tree_1 by tree_2"

	new_tree = tree_1

	#id_1 = 0
	#id_2 = 0
	#node_1 = category_get_root_node (tree_1)
	#node_2 = category_get_root_node (tree_2)
	#
	#while 1:
	#	name_1 = node_1["name"]
	#	name_2 = node_2["name"]
	#	
	#	if(cmp_strings(name_1, name_2) == 0):
	#		next_1 = node_1["next"]
	#		next_2 = node_2["next"]
	#
	#		#if
	#	else:
	#		break
	#	# end if
	# end while

	return new_tree

