
# ----------------------------------------------------------
# advas
# advanced search algorithms implemented as a python module
#
# (C) 2002 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
#
# example for using the successor variety stemmer
#
# ----------------------------------------------------------

# changed 2002-08-23

# import advas module
import advas

# a line of text
line = "footnote, footpath, footman, footing, footie, foothold, footprint, footmark, foodstep, footwork, footer, footage, football, footballer, footlights, footrest, footwear, footstool, foot, foreign, foreigner, foreleg, forelock, foreman, foremost, forename, forenoon, forensic, foresee, foreseeable, forest, forestry, forever, forge, forger, forgery, forget, forgot"
print "text: " + line + "\n"

# split text
words = advas.split_line (line)

print "version 1:\nused dictionary: wordlist"
print words

# use this word
term = "homework"

# calc successor variety for the list of words
# result = advas.calc_succ_variety (words, 1)
result1 = advas.calc_succ_variety (words, 1)

# use a file as word_list
file_name = "/usr/share/dict/words"

print '\nversion 2:\nused dictionary: %s (45.000 words)\n' % file_name
result2 = advas.calc_succ_variety (file_name, 2)

for i in term:
	print '%s : %3d %3d' % (i, result1[i], result2[i])
# end for

# try stemming
result3 = advas.successor_variety_stemmer (term, words, 1)
print "version 3:\nused dictionary: wordlist"
print result3

print '\nversion 4:\nused dictionary: %s (45.000 words)\n' % file_name
result4 = advas.successor_variety_stemmer (term, file_name, 2)
print result4
