# ----------------------------------------------------------------------------
# - adp-start                                                                -
# - afnix:adp starter module                                                 -
# ----------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - project load section                                                     -
# ----------------------------------------------------------------------------

interp:load "adp-prjld"
interp:load "adp-postl"

# ----------------------------------------------------------------------------
# - main section                                                             -
# ----------------------------------------------------------------------------

# check for xhtml mode
if (afnix:adp:options:get-unique-option 'x') {
  try {
    # load the xhtml writer
    interp:load "adp-xhtmw"
    # create a new context
    const ctx (afnix:adp:xhtwr)
    # get the uri name from the arguments
    const uri (afnix:adp:options:get-uri-name)
    # process the uri
    ctx:process uri
  } {
    errorln "error: " what:reason
    afnix:sys:exit 1
  }
}

# check for nroff manual mode
if (afnix:adp:options:get-unique-option 'm') {
  #try {
    # load the nroff manual writer
    interp:load "adp-manmw"
    # create a new context
    const ctx (afnix:adp:manwr)
    # get the uri name from the arguments
    const uri (afnix:adp:options:get-uri-name)
    # process the uri
    ctx:process uri
  #} {
  #  errorln "error: " what:reason
  #  afnix:sys:exit 1
  #}
}
