// ---------------------------------------------------------------------------
// - ctrm.hxx                                                                -
// - standard system library - c terminal platform native functions          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (AFNIX_PLATFORM_PROCID == AFNIX_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif

// linux platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_LINUX)
#define  AFNIX_HAVE_WINSIZE
#define  AFNIX_HAVE_DELTERM
#define  AFNIX_HAVE_NONCONST_TIGET
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <curses.h>
#include <term.h>
#endif

// solaris platform - the include files are completly messed up
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_SOLARIS)
#define  AFNIX_HAVE_WINSIZE
#define  AFNIX_HAVE_DELTERM
#define  AFNIX_HAVE_COMPLEX_TPARM
#define  AFNIX_HAVE_NONCONST_TIGET
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#if (AFNIX_PLATFORM_MAJOR == 5) && (AFNIX_PLATFORM_MINOR < 7)
#include <curses.h>
#include <term.h>
#else
#define __lint
#include <curses.h>
#include <term.h>
#undef __lint
#endif
#endif

// freebsd platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_FREEBSD)
#define  AFNIX_HAVE_WINSIZE
#define  AFNIX_HAVE_NONCONST_TIGET
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <curses.h>
#include <term.h>
#ifdef bool
#undef bool
#endif
#endif

// darwin platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_DARWIN)
#define  AFNIX_DELETE_ISBS
#define  AFNIX_HAVE_WINSIZE
#define  AFNIX_HAVE_NONCONST_TIGET
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <curses.h>
#include <term.h>
#ifdef bool
#undef bool
#endif
#endif

// gnu/freebsd platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_GNUKBSD)
#define  AFNIX_HAVE_WINSIZE
#define  AFNIX_HAVE_DELTERM
#define  AFNIX_HAVE_NONCONST_TIGET
#include <stdlib.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <curses.h>
#include <term.h>
#endif
